/*____________________________________________________________________________
	
	Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

	Portions Copyright (C) 1998-1999 EMusic.com

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
	
	$Id: pmi.h,v 1.7 2003/09/16 17:35:01 kgk Exp $
____________________________________________________________________________*/

#ifndef INCLUDED_PMI_H_
#define INCLUDED_PMI_H_

/* system headers */
#include <stdlib.h>
#include <assert.h>

#include "config.h"

#if HAVE_UNISTD_H
#include <unistd.h>
#elif HAVE_IO_H
#include <io.h>
#else 
#error Must have unistd.h or io.h!
#endif // HAVE_UNISTD_H

/* project headers */
#include "pipeline.h"
#include "thread.h"
#include "errors.h"
#include "eventdata.h"

#define SEEK_FROM_START		SEEK_SET
#define SEEK_FROM_CURRENT	SEEK_CUR
#define SEEK_FROM_END		SEEK_END

const int32_t iDefaultBufferSize = 65536;
const int32_t iDefaultOverflowSize = 16384; 

class PhysicalMediaInput : public PipelineUnit
{
public:
    PhysicalMediaInput(FAContext *context);
    virtual ~PhysicalMediaInput();

    /** Sets the pmi to get the data from the supplied url.
     */
    virtual Error SetUrl(const std::string& url);

    /** Returns the current Url */
    virtual const std::string& GetUrl() const { return m_path; }

    virtual Error Close();
    virtual Error Open() = 0;

    /** Gets the output buffer of this stream.  Because the output
     *  buffer will be prepared for the caller, this function should
     *  be called only once.
     *
     *  @param pBuffer is set to the output buffer. Normally it will
     *  be prepared for the caller.
     *
     *  @returns Returns an error if one happened.
     */
    virtual Error GetOutputBuffer(PullBuffer **pBuffer) = 0;

    /** Moves the current position in the file.
     *
     *  @param offset The pos to move to
     *
     *  @param whence Added to offest or special constants. See fseek
     *
     *  @return can return kError_FileSeekNotSupported or kError_SeekFailed
     */
    virtual Error Seek(int32_t offset, int32_t whence) { 
        return kError_FileSeekNotSupported; 
    }

    /** Return the current position in the stream.
     *  @param pos The current pos in the stream
     *  @return can return kError_FileSeekNotSupported or kError_SeekFailed
     */
    virtual Error Tell(int32_t* pos) { return kError_FileSeekNotSupported; }
    virtual bool  CanHandle(const char *szUrl, char *szTitle) { return false; }
    virtual Error GetLength(size_t &iSize) { 
        return kError_FileSeekNotSupported; 
    }

    /** Returns true if this pipeline is streaming
     *  Want to remove this. Only used in two cases and only to
     *  check if ChangePosition works (Ralf)
     */
    virtual bool  IsStreaming() { return false; }
    virtual bool  UseBufferReduction() { return false; }
    virtual bool  PauseLoop(bool bLoop) { return false; }
    virtual std::vector<std::string> *GetProtocols() = 0;

protected:

    std::string  m_path;
};

#endif /* _PMI_H_ */

/* arch-tag: dc8f6729-30bc-4f69-b00d-e4713fd1577c
   (do not change this comment) */
