#line 13 "float.nw"
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "debug.h"
#include "run.h"
#include "heap.h"
#include "stack.h"
#include "eval.h"
#include "threads.h"
#include "cam.h"
#include "trace.h"

#line 33 "float.nw"
DECLARE_ENTRYPOINT(__primAddFloat);
DECLARE_LABEL(__primAddFloat_1);

FUNCTION(__primAddFloat)
{
    Node *aux;

    EXPORT_LABEL(__primAddFloat)
 ENTRY_LABEL(__primAddFloat)
    EVAL_RIGID_FLOAT(__primAddFloat);
    aux   = sp[0];
    sp[0] = sp[1];
    sp[1] = aux;
    GOTO(__primAddFloat_1);
}

static
FUNCTION(__primAddFloat_1)
{
    double d, e;
    Node   *r;

 ENTRY_LABEL(__primAddFloat_1)
    EVAL_RIGID_FLOAT(__primAddFloat_1);
    get_float_val(d, sp[1]->f);
    get_float_val(e, sp[0]->f);
    sp += 2;

    CHECK_HEAP(float_node_size);
    r	    = (Node *)hp;
    r->info = &float_info;
    put_float_val(r->f, d + e);
    hp += float_node_size;
    RETURN(r);
}


DECLARE_ENTRYPOINT(__primSubFloat);
DECLARE_LABEL(__primSubFloat_1);

FUNCTION(__primSubFloat)
{
    Node *aux;

    EXPORT_LABEL(__primSubFloat)
 ENTRY_LABEL(__primSubFloat)
    EVAL_RIGID_FLOAT(__primSubFloat);
    aux   = sp[0];
    sp[0] = sp[1];
    sp[1] = aux;
    GOTO(__primSubFloat_1);
}

static
FUNCTION(__primSubFloat_1)
{
    double d, e;
    Node   *r;

 ENTRY_LABEL(__primSubFloat_1)
    EVAL_RIGID_FLOAT(__primSubFloat_1);
    get_float_val(d, sp[1]->f);
    get_float_val(e, sp[0]->f);
    sp += 2;

    CHECK_HEAP(float_node_size);
    r	    = (Node *)hp;
    r->info = &float_info;
    put_float_val(r->f, d - e);
    hp += float_node_size;
    RETURN(r);
}


DECLARE_ENTRYPOINT(__primMulFloat);
DECLARE_LABEL(__primMulFloat_1);

FUNCTION(__primMulFloat)
{
    Node *aux;

    EXPORT_LABEL(__primMulFloat)
 ENTRY_LABEL(__primMulFloat)
    EVAL_RIGID_FLOAT(__primMulFloat);
    aux   = sp[0];
    sp[0] = sp[1];
    sp[1] = aux;
    GOTO(__primMulFloat_1);
}

static
FUNCTION(__primMulFloat_1)
{
    double d, e;
    Node   *r;

 ENTRY_LABEL(__primMulFloat_1)
    EVAL_RIGID_FLOAT(__primMulFloat_1);
    get_float_val(d, sp[1]->f);
    get_float_val(e, sp[0]->f);
    sp += 2;

    CHECK_HEAP(float_node_size);
    r	    = (Node *)hp;
    r->info = &float_info;
    put_float_val(r->f, d * e);
    hp += float_node_size;
    RETURN(r);
}

DECLARE_ENTRYPOINT(__primDivFloat);
DECLARE_LABEL(__primDivFloat_1);

FUNCTION(__primDivFloat)
{
    Node *aux;

    EXPORT_LABEL(__primDivFloat)
 ENTRY_LABEL(__primDivFloat)
    EVAL_RIGID_FLOAT(__primDivFloat);
    aux   = sp[0];
    sp[0] = sp[1];
    sp[1] = aux;
    GOTO(__primDivFloat_1);
}

static
FUNCTION(__primDivFloat_1)
{
    double d, e;
    Node   *r;

 ENTRY_LABEL(__primDivFloat_1)
    EVAL_RIGID_FLOAT(__primDivFloat_1);
    get_float_val(d, sp[1]->f);
    get_float_val(e, sp[0]->f);
    sp += 2;

    CHECK_HEAP(float_node_size);
    r	    = (Node *)hp;
    r->info = &float_info;
    put_float_val(r->f, d / e);
    hp += float_node_size;
    RETURN(r);
}

#line 184 "float.nw"
DECLARE_ENTRYPOINT(__floatFromInt);

FUNCTION(__floatFromInt)
{
    long i;
    Node *r;

    EXPORT_LABEL(__floatFromInt)
 ENTRY_LABEL(__floatFromInt)
    EVAL_RIGID_INT(__floatFromInt);
    i	= int_val(sp[0]);
    sp += 1;

    CHECK_HEAP(float_node_size);
    r	    = (Node *)hp;
    r->info = &float_info;
    put_float_val(r->f, i);
    hp += float_node_size;
    RETURN(r);
}


DECLARE_ENTRYPOINT(__truncateFloat);

FUNCTION(__truncateFloat)
{
    double d;
    Node   *r;

    EXPORT_LABEL(__truncateFloat)
 ENTRY_LABEL(__truncateFloat)
    EVAL_RIGID_FLOAT(__truncateFloat);
    get_float_val(d, sp[0]->f);
    sp += 1;

#if ONLY_BOXED_OBJECTS
    CHECK_HEAP(int_node_size);
    r	    = (Node *)hp;
    r->info = &int_info;
    r->i.i  = (int)d;
    hp	   += int_node_size;
#else
    r = mk_int((int)d);
#endif
    RETURN(r);
}


DECLARE_ENTRYPOINT(__roundFloat);

FUNCTION(__roundFloat)
{
    double d, frac;
    Node   *r;

    EXPORT_LABEL(__roundFloat)
 ENTRY_LABEL(__roundFloat)
    EVAL_RIGID_FLOAT(__roundFloat);
    get_float_val(d, sp[0]->f);
    sp += 1;
#define odd(n) (n & 0x01)
    frac = modf(d, &d);
    if ( frac > 0.5 || (frac == 0.5 && odd((int)d)) )
	d += 1.0;
    else if ( frac < -0.5 || (frac == -0.5 && odd((int)d)) )
	d -= 1.0;
#undef odd

#if ONLY_BOXED_OBJECTS
    CHECK_HEAP(int_node_size);
    r	    = (Node *)hp;
    r->info = &int_info;
    r->i.i  = (int)d;
    hp	   += int_node_size;
#else
    r = mk_int((int)d);
#endif
    RETURN(r);
}
