#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../include/Y2/Y.h"
#include "../include/Y2/Ylib.h"

#include "../include/string.h"


static void print_help(void);


#define MIN(a,b)        ((a) < (b) ? (a) : (b))
#define MAX(a,b)        ((a) > (b) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define ABSOLUTE(x)     (((x) < 0) ? ((x) * -1) : (x))


/*
 *      Prints help message.
 */
static void print_help(void)
{
	printf("\
Usage: yshutdown [options]\n\
\n\
    [options] can be any of the following:\n\
\n\
        --recorder <address:port>    Specify which Y server to connect to.\n\
\n\
    Return values:\n\
\n\
        0       Success.\n\
        1       General error.\n\
        2       Cannot connect to Y server error.\n\
        3       Systems error.\n\
\n"
	);
}


int main(int argc, char *argv[])
{
	int i;
	const char *con_arg = NULL;
	YConnection *con = NULL;


	/* Parse arguments. */
	for(i = 1; i < argc; i++)
	{
	    if(argv[i] == NULL)
		continue;

	    /* Help. */
	    if(strcasepfx(argv[i], "--h") ||
               strcasepfx(argv[i], "-h") ||
               !strcmp(argv[i], "?")
	    )
	    {
		print_help();
		return(0);
	    }
	    /* Connect address. */
	    else if(strcasepfx(argv[i], "--rec") ||
                    strcasepfx(argv[i], "-rec")
	    )
	    {
		i++;
		if(i < argc)
		{
		    con_arg = argv[i];
		}
		else
		{
		    fprintf(stderr,
			"%s: Requires argument.\n",
			argv[i - 1]
		    );
		}
	    }
	}


        /* Connect to Y server. */
        con = YOpenConnection(
            NULL,               /* No start argument. */
            con_arg
        );
        if(con == NULL)
        {
            fprintf(stderr, "Cannot connect to Y server");
            if(con_arg == NULL)
                con_arg = getenv("RECORDER");
            if(con_arg == NULL)
                fprintf(stderr, ".\n");
            else
                fprintf(stderr, ": %s\n", con_arg);
            return(2);
        }

	/* Shut down the Y server. */
	YShutdownServer(con);
	con = NULL;

	return(0);
}
