#include <cstdio>

#include "yehia/net/server.h"

namespace Yehia
{

namespace Net
{

using namespace std;


Server::Server()
{
}

Server::Server(ErrorHandler& parent) : ErrorHandler(parent)
{
}

Server::~Server()
{
}

void Server::add_socket(Socket sock)
{
  char buffer[128];
  
  try
  {
    sock.listen();
    HandlerID hid = disp_.add_input_handler(
            bind(slot(*this, &Server::handle_connect), sock), sock);
    sockets_.insert(make_pair(sock, hid));
  }
  catch (Socket::Error& e)
  {
    sprintf(buffer, "listen failed on socket '%d'", sock.fd());
    emit_error(buffer);
  }
}

void Server::remove_socket(Socket sock)
{
  SockMap::iterator it = sockets_.find(sock);
  if (it != sockets_.end())
  {
    // found, remove socket and handler
    disp_.remove(it->second);
    sockets_.erase(it);
  }
}


void Server::handle_connect(Socket sock)
{
  if (!do_accept_on(sock))
    return;
  
  try
  {
    handle_new_connection(sock.accept());  
  }
  catch (Socket::Error& err)
  {
    emit_error(std::string("could not accept connection: ") + err.what());
  }
}

}

}
