#include "FileSpecList.h"

#include "CEgFileSpec.h"
#include "EgOSUtils.h"



FileSpecList::FileSpecList( XStrListOptsT inOption, bool inIgnoreExtns ) :
	AbstractStrList( inOption, sSpecComparitor ) {
	
	mIgnoreExtns = inIgnoreExtns;
}



FileSpecList::~FileSpecList() {
	RemoveAll();
}

		
		




long FileSpecList::AddCopy( const CEgFileSpec& inSpec ) {
	long idx;
		
	idx = mItems.Add( new CEgFileSpec( inSpec ) );
		
	return idx;
}



void FileSpecList::AddCopies( const FileSpecList& inList ) {
	int i, n = inList.Count();
	
	for ( i = 1; i <= n; i++ ) {
		mItems.Add( new CEgFileSpec( *inList.FetchSpec( i ) ) );
	}
}


int FileSpecList::sSpecComparitor( const void* inA, const void* inB, const void* inThis ) {
	bool ignoreExtns	= ( (FileSpecList*) inThis ) -> mIgnoreExtns;
	const UtilStr* a, *b;	
	
	a = ( (const CEgFileSpec*) inA ) -> GetFileName( ignoreExtns );
	b = ( (const CEgFileSpec*) inB ) -> GetFileName( ignoreExtns );

	bool caseSensitive = ((FileSpecList*) inThis) -> mStrOrdering == ASA_Sorted_Case_Sensitive;
	
	if ( a && b )
		return a -> compareTo( b, caseSensitive );
	else
		return 0;
}


const UtilStr* FileSpecList::Fetch( long inIndex ) const	{ 
	CEgFileSpec* spec = (CEgFileSpec*) mItems.Fetch( inIndex );
	
	if ( spec )
		return spec -> GetFileName( mIgnoreExtns );
	else
		return nil;	
}












void FileSpecList::ScanFolder( CEgFileSpec& inFolder ) {
	CEgFileSpec spec;
	long index = OSU_FIRST_FILE;
		
	// Make a file spec list of what's in the folder
	RemoveAll();	
	while ( EgOSUtils::GetNextFile( inFolder, spec, OSU_DO_FILES, &index ) ) {
		AddCopy( spec );
	}	
}


void FileSpecList::SubScanFolder( CEgFileSpec& inFolder ) {
	CEgFileSpec spec;
	long index = OSU_FIRST_FILE;
	
	// Make a file spec list of what's in the folder
	RemoveAll();	
	while ( EgOSUtils::GetNextFile( inFolder, spec, OSU_DO_FOLDERS, &index ) ) {
		AddCopy( spec );
	}	
}


