/*
  Load the XMMS InfoPipe configuration from the default XMMS configuration
  file (~/.xmms/config).

  The configuration is stored like this:

    [InfoPipe]
    create_symlinks=TRUE
    delete_symlinks=FALSE
    do_chown=FALSE
    chown_to_uid=501
    chown_to_gid=100

  The first two tell whether the "legacy" symlinks should be created/deleted,
  do_chown tells whether the pipe should be chown()ed, and the last two
  tell what uid and gid the pipe should be chown()ed to...

  $Id: infopipe_config.c,v 1.3 2002/05/19 11:00:12 wwwwolf Exp $
 */

#include <glib.h>
#include <unistd.h>
#include <sys/types.h>
#include <xmms/configfile.h>

#include "infopipe_config.h"
#include "infopipe.h"

/*
  The structure where runtime parameters are stored.
 */
InfoPipeConf param;

void load_config(void)
{
  ConfigFile *cfg;
  gboolean save;

  /* Is it necessary to save? Not yet! */
  save = FALSE;

  /* Open the default config file (~/.xmms/config) */
  cfg = xmms_cfg_open_default_file();

  /* Couldn't open? We really should have a default config file! */
  if(!cfg) {
    perror("Unable to open the default XMMS config file");
    xmms_quit();
  }

  /* Default values */
  param.create_symlinks = TRUE;
  param.delete_symlinks = FALSE;
  param.chowntouid = (gint) getuid();
  param.chowntogid = (gint) getgid();

  /* Read information... */
  xmms_cfg_read_boolean(cfg, "InfoPipe", "create_symlinks",
			&param.create_symlinks);
  xmms_cfg_read_boolean(cfg, "InfoPipe", "delete_symlinks",
			&param.delete_symlinks);
  xmms_cfg_read_boolean(cfg, "InfoPipe", "do_chown",
			&param.do_chown);
  xmms_cfg_read_int(cfg, "InfoPipe", "chown_to_uid",
		    &param.chowntouid);
  xmms_cfg_read_int(cfg, "InfoPipe", "chown_to_gid",
		    &param.chowntogid);

  /* ...and save information, in case it wasn't there... */
  xmms_cfg_write_boolean(cfg, "InfoPipe", "create_symlinks",
			 param.create_symlinks);
  xmms_cfg_write_boolean(cfg, "InfoPipe", "delete_symlinks",
			 param.delete_symlinks);
  xmms_cfg_write_boolean(cfg, "InfoPipe", "do_chown",
			 param.do_chown);
  xmms_cfg_write_int(cfg, "InfoPipe", "chown_to_uid",
		     param.chowntouid);
  xmms_cfg_write_int(cfg, "InfoPipe", "chown_to_gid",
		     param.chowntogid);

  /* Write it out and get rid of our config object. */
  xmms_cfg_write_default_file(cfg);
  xmms_cfg_free(cfg);
}


