/*
 * Copyright (C) 2002-2003 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#ifdef HAVE_DIRENT_H
#include <dirent.h>
#endif
#include <errno.h>
#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#ifdef HAVE_REGEX_H
#include <regex.h>
#endif
#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <glob.h>
#include <dbh.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include <libxfce4util/util.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "add_file.h"
#include "add_node_contents.h"
#include "dummies.h"
#include "entry.h"
#include "filter.h"
#include "gdir.h"
#include "misc.h"
#include "refresh.h"
#include "widgets.h"
#include "input.h"

/*#define DEBUG*/

extern int stop;

static DBHashTable *bookmarks = NULL;
static DBHashTable *newbookmarks = NULL;
static GtkTreeIter *target_iter;
static GtkTreeView *target_treeview;
static int bookmarks_count;
static unsigned int smallcount, countbyte;
static int target_type;
static regex_t *target_preg;
static gdir_t bm_gdir;

static GList *d_list = NULL;
static int check_dir(char *path);

extern gchar *bookfile;
extern root_t root[];
void set_book_combo(GtkTreeView * treeview)
{
    GList *tmp,*new_list = NULL;
    /*GtkEntry *entry;*/
    GtkWidget *w = lookup_widget((GtkWidget *)treeview, "input_combo");
	glob_t dirlist;
	int i;
    	char bm_dir[_POSIX_PATH_MAX];
	gchar *globstring;
        xfce_get_userfile_r(bm_dir, _POSIX_PATH_MAX-1, "xffm");
	globstring = g_strconcat(bm_dir,"/*.bm.dbh",NULL);
	
	if (glob (globstring, GLOB_ERR, NULL, &dirlist) != 0) {
		return;
	} else {
	   for (i = 0; i < dirlist.gl_pathc; i++){
	      gchar *p,*g=g_path_get_basename(dirlist.gl_pathv[i]);
	      if(!strstr(g,".bm.dbh")) continue;
	      p=strstr(g,".bm.dbh");
	      *p=0;
	      new_list = g_list_append(new_list, g);
	   }
	}
  	globfree (&dirlist);

    /*entry = (GtkEntry *) lookup_widget((GtkWidget *)treeview, "input_entry");
    gtk_entry_set_text(entry, (gchar *)new_list->data);*/
    
    gtk_combo_set_popdown_strings(GTK_COMBO(w), new_list);
    for (tmp=new_list;tmp;tmp=tmp->next){
	    gchar *g=(gchar *)tmp->data;
	    g_free(g);
	    g=NULL;
    }
    g_list_free(new_list);
}

void reload_book(GtkTreeView *treeview){
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    GtkTreePath *treepath;
    tree_entry_t *en;
    GtkTreeIter iter;
    get_bookmark_root(treeview,&iter, &en);
    treepath = gtk_tree_model_get_path(treemodel, &iter);
    clear_dnd_selection_list();
    gtk_tree_selection_select_path (selection,treepath);
    gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
    gtk_tree_path_free(treepath);
    gtk_tree_store_set((GtkTreeStore *) treemodel, &iter, 
			NAME_COLUMN, 
			(bookfile)?my_utf_string(bookfile):
			my_utf_string(_(root[ROOT_BOOKMARKS].label)),
		       	-1);
    on_refresh((GtkButton *) treeview,NULL);
}


char *get_bookfile_path(void){
    static char bookmarks_path[_POSIX_PATH_MAX];
    gchar *g;
    xfce_get_userfile_r(bookmarks_path, _POSIX_PATH_MAX-1, "xffm");
    if(!check_dir(bookmarks_path)) return NULL;
    if (bookfile) {
	    g=g_strconcat("xffm/",bookfile,".bm.dbh",NULL);
	    xfce_get_userfile_r(bookmarks_path, _POSIX_PATH_MAX-1,
		    g);
	    g_free(g);
	    g=NULL;
    } else xfce_get_userfile_r(bookmarks_path, _POSIX_PATH_MAX-1,
		    "xffm%cbookmarks.dbh", G_DIR_SEPARATOR);
#ifdef DEBUG
    printf("DBG: using %s\n",bookmarks_path);
#endif
    return bookmarks_path;
}


static void bookmarks_dlist(DBHashTable * dbh)
{
    char *fullpath = (char *)DBH_DATA(dbh);
    struct stat st;
    stat(fullpath, &st);
    if(S_ISDIR(st.st_mode))
    {
	d_list = g_list_append(d_list, g_strdup(fullpath));
    }
}


GList *get_bookmark_dirlist(void)
{
    char *bookmarks_path=get_bookfile_path();
    d_list = NULL;

    if (!bookmarks_path) return NULL;
    chmod(bookmarks_path,S_IRUSR|S_IWUSR);
    if((bookmarks = DBH_open(bookmarks_path)) == NULL)
	return NULL;
    DBH_foreach_sweep(bookmarks, bookmarks_dlist);
    DBH_close(bookmarks);
    return d_list;
}


static int check_dir(char *path)
{
    struct stat st;
    if(stat(path, &st) < 0)
    {
	if(mkdir(path, 0770) < 0)
	    return FALSE;
	return TRUE;
    }
    if(S_ISDIR(st.st_mode))
    {
	if(access(path, W_OK) < 0)
	    return FALSE;
	return TRUE;
    }
    return FALSE;
}

static void add2treeview(GtkTreeView * treeview, char *path)
{
    char *name = path;
    GtkTreePath *treepath;
    GtkTreeIter target;
    gboolean is_net_stuff=FALSE;
    tree_entry_t *en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    if (strncmp(path,"smb://",strlen("smb://"))==0 ||
	strncmp(path,"SMB://",strlen("SMB://"))==0    ) {
	    is_net_stuff=TRUE;
	    name=strchr(path,'@')+1;
    } else if(strlen(path) > 1)
    {
	name = strrchr(path, '/');
	if(!name)
	    g_assert_not_reached();
	name++;
    }
    get_bookmark_root(treeview, &target, &en);
#ifdef DEBUG
    printf("DBG:add2treeview(%s)\n",(en->path)?en->path:"null");
#endif
    /*if(!IS_EXPANDED(en->type))return;*/
    if (!IS_LOADED(en->type)) SET_LOADED(en->type);
    
    if (is_net_stuff){
          en=mk_net_entry(path,en->type);
    }
    else en = stat_entry(path, en->type);
    prepend_file(treeview, &target, en, name);
    erase_dummy(treeview, &target);

    /* expand + scroll to */
    treepath = gtk_tree_model_get_path(treemodel, &target);
    gtk_tree_view_expand_row(treeview, treepath, FALSE);
    gdk_flush();
    gtk_tree_view_scroll_to_cell(treeview, treepath, NULL, TRUE, 0.0, 0.0);
    gtk_tree_path_free(treepath);
    /*SET_LOADED(en->type); bug? */

    return;
}

int add2bookmarks(GtkTreeView * treeview, char *path)
{
    char *bm=get_bookfile_path();
    struct stat st;
    GString *gs;
    tree_entry_t *en;
    GtkTreeIter target;
    GtkTreePath *treepath;
    gboolean is_net_stuff=FALSE;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_details_t *tree_details = get_tree_details(treeview);
    gchar *d_path=NULL;

    if (strncmp(path,"smb://",strlen("smb://"))==0||
	strncmp(path,"SMB://",strlen("SMB://"))==0) {
	    is_net_stuff=TRUE;
    }
    else {
	    if (lstat(path, &st) < 0) return -1;
    }

    get_bookmark_root(treeview, &target, &en);
    treepath = gtk_tree_model_get_path(treemodel, &target);
    gtk_tree_view_expand_row(treeview, treepath, FALSE);
    gtk_tree_path_free(treepath);

    process_pending_gtk();

    /* keep file protected. */
    chmod(bm,S_IRUSR|S_IWUSR);
    if((bookmarks = DBH_open(bm)) == NULL)
    {
	if((bookmarks = DBH_create(bm, 11)) == NULL)
	    return -1;
    }

    if (is_net_stuff)
    {
	gchar *g;
	d_path=g_strconcat("//",strchr(path,'@')+1,NULL);
	if (d_path[strlen(d_path)-1]==':') *(strrchr(d_path,':'))=0;
	for (g=d_path;*g;g++) if (*g==':'){*g='/'; break;}
    }
    else d_path=g_strdup(path);
    
    gs = g_string_new(d_path);
    sprintf((char *)DBH_KEY(bookmarks), "%10u", g_string_hash(gs));
    g_string_free(gs, TRUE);
    /*printf("DBG: bookmarking with key=%s\n",d_path);*/
    
    if(!DBH_load(bookmarks))
    {

	memcpy(DBH_DATA(bookmarks), (void *)path, strlen(path) + 1);
	DBH_set_recordsize(bookmarks, strlen(path) + 1);
	if(!DBH_update(bookmarks))
	{
	    print_diagnostics(treeview, "xf_ERROR_ICON", d_path, " ", _("NOT booked"), " (", DBH_KEY(bookmarks), ")\n", NULL);
	}
	else
	{
	    add2treeview(treeview, path);
	    print_diagnostics(treeview, "xf_INFO_ICON", d_path, " ", _("booked"), "\n", NULL);
	    if(d_path && strlen(d_path) >= 2)
		print_status(treeview, "xf_INFO_ICON", __VY_FN__(d_path), " ", _("booked"), NULL);

	}
	DBH_close(bookmarks);
	unset_load_wait(&tree_details);
	g_free(d_path);
	d_path=NULL;
	return TRUE;
    }
    print_diagnostics(treeview, "xf_WARNING_ICON", path, " ", _("already in book"), "\n", NULL);
    DBH_close(bookmarks);
    g_free(d_path);
    d_path=NULL;
    return FALSE;
}


static void count_bookmarks(DBHashTable * dbh)
{
    bookmarks_count++;
    return;
}

static void add_bookmarks(DBHashTable * dbh)
{
    char *p;
    struct stat st;
    char *fullpath = (char *)DBH_DATA(dbh);

    if (strncmp(fullpath,"smb://",strlen("smb://"))==0||
	strncmp(fullpath,"SMB://",strlen("SMB://"))==0	    )
    	    p = strrchr(fullpath, '@');
    else
	    p = strrchr(fullpath, '/');

    /*printf("DBG:%s -> %s\n",fullpath,p); */
    if(!p || strlen(p) <= 1) return;
    p++;
    if(regexec(target_preg, (const char *)p, 0, NULL, 0))
	return;

    if(stat(fullpath, &st) >= 0){
    	bm_gdir.gl[bm_gdir.pathc].en = stat_entry(fullpath, target_type);
    } 
    else if (strncmp(fullpath,"smb://",strlen("smb://"))==0||
	strncmp(fullpath,"SMB://",strlen("SMB://"))==0){
          bm_gdir.gl[bm_gdir.pathc].en=mk_net_entry(fullpath,target_type);
    } else return;
    if(!bm_gdir.gl[bm_gdir.pathc].en) g_assert_not_reached();
         
    bm_gdir.gl[bm_gdir.pathc].pathv = g_strdup(p);
    bm_gdir.pathc++;
    return;
}


int open_bookmarks(GtkTreeView * treeview, GtkTreeIter * iter, GtkTreePath * treepath, gpointer user_data)
{
    char *bookmarks_path=get_bookfile_path();
    tree_entry_t *en = get_entry(treeview, iter);
    tree_details_t *tree_details = get_tree_details(treeview);
    if (!bookmarks_path) return -1;

    target_iter = iter;
    target_treeview = treeview;
    target_type = en->type;
 
    smallcount = 0, countbyte = 0x10;	/* for dummy tag */
    bookmarks_count = 0;	/* for count step */
    bm_gdir.pathc = 0;		/* for read step */
    chmod(bookmarks_path,S_IRUSR|S_IWUSR);
    if((bookmarks = DBH_open(bookmarks_path)) == NULL)
	return -1;
    /*printf("DBG:opening book\n"); */
    
    cursor_wait(treeview);

/* returns compiled regex and sets filter in tree_entry */
    target_preg = get_regex_filter(treeview, en);

    /*printf("DBG:counting book elements\n"); */

    DBH_foreach_sweep(bookmarks, count_bookmarks);
    /*printf("DBG:pathc=%d\n",bm_gdir.pathc); */

    if(DBH_ERASED_SPACE(bookmarks))
    {
	/*printf("DBG: erased space=%d\n",DBH_ERASED_SPACE(bookmarks)); */
	SET_ERASED_SPACE(en->type);
    }
    else
	UNSET_ERASED_SPACE(en->type);
    if(bookmarks_count)
    {
	bm_gdir.gl = (dir_t *) malloc(bookmarks_count * sizeof(dir_t));
	if(!bm_gdir.gl)
	    g_assert_not_reached();
	DBH_foreach_sweep(bookmarks, add_bookmarks);
	/*printf("DBG:count=%d\n",bookmarks_count); */
	if(bookmarks_count != bm_gdir.pathc)
	{
	    /* printf("DBG: %s=%d, %s=%d", "listed", bm_gdir.pathc,
			    "counted", bookmarks_count);*/
	    /*print_diagnostics(treeview, "xf_WARNING_ICON", 
			    _("book needs a purge"), "\n", 
			    NULL);*/
	    SET_ERASED_SPACE(en->type);
	}
	add_node_contents(treeview, iter, &bm_gdir);
	gdirfree(&bm_gdir);
    }
    else
    {
	SET_LOADED(en->type);
	reset_dummy(treeview, iter, 0);
    }
    DBH_close(bookmarks);

    if(!en->tag)
	en->tag = (char *)malloc(_POSIX_PATH_MAX);
    if(stop)
    {
	stop = FALSE;
	sprintf(en->tag, "%s : %s", FILENAME(en),
		strerror(ETIMEDOUT));
    }
    else
    {
	hide_stop(tree_details->window);
	sprintf(en->tag, "%s : %d %s", _("Book"), bm_gdir.pathc, _("items"));
	if (!bm_gdir.pathc){
	   char *bp=get_bookfile_path();
	   reset_dummy(treeview, iter, 3);
	   /* do an automatic purge:  NO!!!*/
	   /*unlink(bp);*/
	}
	
    }

    /*gtk_widget_thaw_child_notify  ((GtkWidget *)treeview);*/
    regfree(target_preg);
    cursor_reset(treeview);

    return 0;
}

/* This is basically a DBH_regen(), except that temporary file is
 * within the scope of xffm, not dbh */

void purge_bookmarks(DBHashTable * dbh)
{
    struct stat st;
    char *p;
    char *fullpath = (char *)DBH_DATA(dbh);

    if(!newbookmarks)
	g_assert_not_reached();
    p = strrchr(fullpath, '/');
    if(p)
    {
	p++;
	if(stat(fullpath, &st) < 0)
	    return;
    }
    /* copy the key from the old record to the new record */
    memcpy(DBH_KEY(newbookmarks), DBH_KEY(bookmarks), DBH_KEYLENGTH(bookmarks));
    /* copy the data from the old record to the new record */
    memcpy(newbookmarks->data, bookmarks->data, DBH_RECORD_SIZE(bookmarks));
    /* I always forget this instruction, and it is the most important
     * (since DBH records have a variable size): */
    DBH_set_recordsize(newbookmarks, DBH_RECORD_SIZE(bookmarks));
    /* write the record to the new file; */
    if(!DBH_update(newbookmarks))
	g_assert_not_reached();
    /*printf("DBG:clean record: %s\n",fullpath); */
    return;
}



/****  callbacks *********/

void on_clear_all_bookmarks_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    char *bm=get_bookfile_path();
    GtkTreeIter iter, parent;
    tree_entry_t *en;
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);

    get_bookmark_root(treeview, &parent, &en);
    while(gtk_tree_model_iter_children(treemodel, &iter, &parent))
    {
	gtk_tree_store_remove((GtkTreeStore *) treemodel, &iter);
    }
    add_dummy(treeview, &parent);
    reset_dummy(treeview, &parent, 3);
    unlink(bm);
    UNSET_ERASED_SPACE(en->type);

}




void on_purge_bookmarks1_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    tree_details_t *tree_details = get_tree_details(treeview);
    GtkTreeIter iter;
    tree_entry_t *en;
    char fname[_POSIX_PATH_MAX];
    char *bookmarks_path=get_bookfile_path();

    if (!bookmarks_path) return;
    xfce_get_userfile_r(fname, _POSIX_PATH_MAX-1, "xffm");
    chdir(fname);
    strcpy(fname, "bookmarks.XXXXXX");
    close(mkstemp(fname));

    chmod(bookmarks_path,S_IRUSR|S_IWUSR);
    bookmarks = DBH_open(bookmarks_path);
    newbookmarks = DBH_create(fname, DBH_KEYLENGTH(bookmarks));
    DBH_foreach_sweep(bookmarks, purge_bookmarks);
    DBH_close(bookmarks);
    DBH_close(newbookmarks);
    rename(fname, bookmarks_path);
    get_bookmark_root(treeview, &iter, &en);
    UNSET_ERASED_SPACE(en->type);
    on_refresh((GtkButton *) tree_details->window, NULL);

}

void on_remove_from_bookmarks_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    char *bm=get_bookfile_path();
    GtkTreeIter iter, parent;
    tree_entry_t *en;
    GtkTreeView *treeview = get_selected_treeview((GtkWidget *) menuitem);
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);

    /*get selection */
    en = get_selected_entry(treeview, &iter);
    if(!en)
	g_assert_not_reached();

    chmod(bm,S_IRUSR|S_IWUSR);
    if((bookmarks = DBH_open(bm)) != NULL)
    {
	GString *gs;
	gs = g_string_new(en->path);
	/*printf("DBG: get stringhash =%10u\n", g_string_hash(gs));*/
	sprintf((char *)DBH_KEY(bookmarks), "%10u", g_string_hash(gs));
	g_string_free(gs, TRUE);
	if (!DBH_erase(bookmarks)){
		printf("DBG: cannot erase %s\n",en->path);
	}
	DBH_close(bookmarks);
    }
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_BROWSE);
    if(gtk_tree_selection_get_selected(selection, &treemodel, &iter))
    {

	gtk_tree_store_remove((GtkTreeStore *) treemodel, &iter);
    }
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
    get_bookmark_root(treeview, &parent, &en);
    if(!gtk_tree_model_iter_children(treemodel, &iter, &parent))
    {
	add_dummy(treeview, &parent);
	reset_dummy(treeview, &parent, 3);
    }
    SET_ERASED_SPACE(en->type);
}


void
on_save_book                           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    show_input(treeview, SAVE_BOOK_INPUT);

}

