/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.pattern;

import com.icl.saxon.Context;
import com.icl.saxon.NameTest;
import com.icl.saxon.expr.AnyNameTest;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.ParentNodeExpression;
import com.icl.saxon.expr.PathExpression;
import com.icl.saxon.expr.Step;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.VariableReference;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.AnyChildNodePattern;
import com.icl.saxon.pattern.FirstElementPattern;
import com.icl.saxon.pattern.NamedNodePattern;
import com.icl.saxon.pattern.NodeTestPattern;
import com.icl.saxon.pattern.Pattern;
import java.util.Vector;
import org.xml.sax.SAXException;

public class LocationPathPattern
extends Pattern {
    public Pattern parentPattern = null;
    public Pattern ancestorPattern = null;
    public NameTest nameTest = new AnyNameTest();
    public int nodeType = 0;
    protected Vector filters = new Vector(3);
    protected Expression extent = null;

    public void addFilter(Expression expression) {
        this.filters.addElement(expression);
    }

    public Pattern simplify() throws SAXException {
        Object object;
        if (this.parentPattern == null && this.ancestorPattern == null && this.filters.size() == 0) {
            if (this.nameTest instanceof AnyNameTest) {
                if (this.nodeType == 0) {
                    return new AnyChildNodePattern();
                }
                return new NodeTestPattern(this.nodeType);
            }
            return new NamedNodePattern(this.nodeType, this.nameTest);
        }
        if (this.parentPattern != null) {
            this.parentPattern = this.parentPattern.simplify();
        }
        if (this.ancestorPattern != null) {
            this.ancestorPattern = this.ancestorPattern.simplify();
        }
        int n = 0;
        while (n < this.filters.size()) {
            object = (Expression)this.filters.elementAt(n);
            if ((object = ((Expression)object).simplify()) instanceof BooleanValue && ((Value)object).asBoolean()) {
                this.filters.removeElementAt(n);
                --n;
            } else {
                this.filters.setElementAt(object, n);
            }
            ++n;
        }
        if (this.nodeType == 1 && this.filters.size() == 1 && this.filters.elementAt(0) instanceof NumericValue && (int)((NumericValue)this.filters.elementAt(0)).asNumber() == 1) {
            object = new FirstElementPattern();
            ((LocationPathPattern)object).nameTest = this.nameTest;
            ((LocationPathPattern)object).nodeType = this.nodeType;
            ((LocationPathPattern)object).parentPattern = this.parentPattern;
            ((LocationPathPattern)object).ancestorPattern = this.ancestorPattern;
            ((LocationPathPattern)object).filters = this.filters;
            return object;
        }
        if (this.isRelative()) {
            this.makeExtent();
        }
        return this;
    }

    private void makeExtent() throws SAXException {
        Step step = new Step(4, this.nodeType, this.nameTest);
        step.setFilters(this.filters);
        this.extent = new PathExpression(new ParentNodeExpression(), step);
    }

    public boolean matchesX(NodeInfo nodeInfo, Context context) throws SAXException {
        System.err.println("Matching node " + nodeInfo + " against LP pattern " + this);
        boolean bl = this.matchesX(nodeInfo, context);
        System.err.println(bl ? "matches" : "no match");
        return bl;
    }

    public boolean matches(NodeInfo nodeInfo, Context context) throws SAXException {
        NodeInfo nodeInfo2;
        if (!nodeInfo.isa(this.nodeType)) {
            return false;
        }
        if (!this.nameTest.isNameOf(nodeInfo)) {
            return false;
        }
        if (this.parentPattern != null) {
            nodeInfo2 = (NodeInfo)nodeInfo.getParentNode();
            if (nodeInfo2 == null) {
                return false;
            }
            if (!this.parentPattern.matches(nodeInfo2, context)) {
                return false;
            }
        }
        if (this.ancestorPattern != null) {
            nodeInfo2 = (NodeInfo)nodeInfo.getParentNode();
            while (!this.ancestorPattern.matches(nodeInfo2, context)) {
                if ((nodeInfo2 = (NodeInfo)nodeInfo2.getParentNode()) != null) continue;
                return false;
            }
        }
        if (this.filters.size() > 0) {
            return this.testFilters(nodeInfo, context);
        }
        return true;
    }

    protected boolean testFilters(NodeInfo nodeInfo, Context context) throws SAXException {
        Context context2 = context.newContext();
        context2.setContextNode(nodeInfo);
        context2.setPosition(1);
        context2.setLast(1);
        if (this.extent != null) {
            NodeSetValue nodeSetValue = (NodeSetValue)this.extent.evaluate(context2);
            if (!nodeSetValue.contains(nodeInfo)) {
                return false;
            }
        } else {
            int n = 0;
            while (n < this.filters.size()) {
                Expression expression = (Expression)this.filters.elementAt(n);
                if (!expression.evaluateAsBoolean(context2)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public int getType() {
        return this.nodeType;
    }

    public Name getName() {
        if (this.nameTest instanceof Name) {
            return (Name)this.nameTest;
        }
        return null;
    }

    public NameTest getNameTest() {
        return this.nameTest;
    }

    public String toString() {
        String string;
        switch (this.nodeType) {
            case 2: {
                string = "@" + this.nameTest.toString();
                break;
            }
            case 1: {
                string = this.nameTest.toString();
                break;
            }
            case 3: {
                string = "text()";
                break;
            }
            case 0: {
                string = "node()";
                break;
            }
            case 4: {
                string = "/";
                break;
            }
            case 8: {
                string = "comment()";
                break;
            }
            case 7: {
                string = "processing-instruction('" + this.nameTest.toString() + "')";
                break;
            }
            default: {
                string = "???";
            }
        }
        int n = 0;
        while (n < this.filters.size()) {
            string = string + "[" + this.filters.elementAt(n).toString() + "]";
            ++n;
        }
        if (this.parentPattern != null) {
            string = this.parentPattern.toString() + "/" + string;
        }
        if (this.ancestorPattern != null) {
            string = this.ancestorPattern.toString() + "/" + string;
        }
        return string;
    }

    public boolean isRelative() throws SAXException {
        int n = 0;
        while (n < this.filters.size()) {
            Expression expression = (Expression)this.filters.elementAt(n);
            if (expression.isNumeric()) {
                return true;
            }
            if (expression instanceof VariableReference) {
                return true;
            }
            if (expression.isRelative()) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

