// $Id: HeightOps.h,v 1.10 2002/10/04 20:59:09 teuf Exp $
#ifndef HEIGHT_OPS_H
#define HEIGHT_OPS_H

#include <vector>

#include <Modules/HeightField/HFWorld.h>
#include "HFEditHeight.h"

class HeightOp
{
   public:
      HeightOp (const std::string& name, const std::string& icon);
      virtual ~HeightOp() {}

      virtual HFEditHeight *Create(World* w, int t, int s,
				   float a, float h) = 0;

   public:
      std::string m_Name;
      std::string m_Icon;
};


// Height operation list, filled with default operations.
class HeightOpList : public std::vector <HeightOp*>
{
   public: 
      HeightOpList();
};

#endif
