/* setfilterop.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: setfilterop.h,v 1.8 2004/10/27 21:09:01 ralf Exp $ */

#ifndef SETFILTEROP_H
#define SETFILTEROP_H

#include "wdefines.h"
#include "functionproto.h"
#include <aguix/util.h>

class Worker;

class SetFilterOp:public FunctionProto
{
public:
  SetFilterOp();
  virtual ~SetFilterOp();
  SetFilterOp( const SetFilterOp &other );
  SetFilterOp &operator=( const SetFilterOp &other );

  virtual SetFilterOp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
#if ! ( defined ( __GNUC__ ) && ( __GNUC__ < 3 ) )
  using FunctionProto::run;
#endif
  virtual int run(ActionMessage*);
  virtual bool save(Datei*);
  virtual const char *getDescription();
  virtual int configure();

  int doconfigure(int mode);
  typedef enum {INCLUDE_FILTER=0,EXCLUDE_FILTER,UNSET_FILTER,UNSET_ALL} setfilterop_mode;
  
  void setRequestFlags( bool );
  void setFilter( const char * );
  void setFiltermode( setfilterop_mode );
protected:
  static const char *name;
  // Infos to save
  bool request_flags;
  char *filter;
  setfilterop_mode filtermode;
  
  // temp variables
  Lister *startlister,*endlister;
  
  // temp values filled when request_flags==true
  char *tfilter;
  setfilterop_mode tfiltermode;

  int normalmodesf();

  void addHistoryItem( const char *str );
  static List *filter_history;
private:
  static int instance_counter;
  static int history_size;
  void initHistory();
  void closeHistory();
};

#endif
