/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000 Ricardo Villalba <rvm@linuxfan.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "intern.h"

#include <stdio.h>
#include <string.h>
#include <qtextcodec.h>

#ifdef HAVE_KDELIBS3
#include <klocale.h>
#include <kglobal.h>
#include <qstring.h>
#endif

char locale_actual[255];

void setLocales() {
#ifdef HAVE_LOCALE_H
	setlocale(LC_ALL, "" );
	setlocale(LC_NUMERIC, "C" );

#ifndef HAVE_KDELIBS3
	bindtextdomain(NLS_CAT_NAME, NLS_LOCALE_PATH);
	textdomain( NLS_CAT_NAME);
#endif

#endif
}

QString i18Traduce(const char *frase) {
#ifdef HAVE_KDELIBS3
	return i18n(frase);
#else
#ifdef HAVE_LOCALE_H
	//return QString::fromLocal8Bit(gettext(frase));
	return QString::fromUtf8(gettext(frase));
#else
	return QString(frase);
#endif
#endif
}

const char * getLocale() {
	locale_actual[0]=0;
	QString locale;
#ifdef HAVE_KDELIBS3
	locale= KGlobal::locale()->language();
#else
	locale= QTextCodec::locale();
#endif

	if (!locale.isEmpty())
		strncpy( locale_actual, locale.latin1() , sizeof(locale_actual)-1) ;

	qDebug("locale_actual: '%s'", locale_actual);
	return locale_actual;
}

QString getDefaultCodecName() {
	QTextCodec *codec = QTextCodec::codecForLocale();
	if (codec)
		return codec->name();
	else
		return "ISO 8859-1";
}

