/*
    This file is part of wmpload - a program to monitor ppp activity for X
    Copyright (C) 1999  Matt Smith <mdsmith@engr.utk.edu>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/*
 * this function came from pppstats.c in the ppp-2.3.5 distributon
 * with the following copyright
 *
 */
 
/*
 * Copyright (c) 1989 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */


/* strioctl.c */

#ifdef STREAMS

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stropts.h>

#include "wmpload.h"

int strioctl(int fd, int cmd, void *ptr, int ilen, int olen)
{
	struct strioctl str;
	
	str.ic_cmd = cmd;
	str.ic_timout = 0;
	str.ic_len = ilen;
	str.ic_dp = ptr;
	
	if (ioctl(fd, I_STR, &str) == -1) return -1;
	
	if (str.ic_len != olen)
		fprintf(stderr,
		"strioctl: expected %d bytes, got %d for cmd 0x%x\n",
		olen, str.ic_len, cmd);
	return 0;
}

#endif
