/*
    This file is part of Waiho (http://info.xdev.org/projets/Waiho)
    Copyright (C) 2001-2002 Nicolas Roard (nicolas@roard.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

@interface File: NSObject
{
    NSString* _file;
    NSString* _link;
    NSString* _localpath;
    NSString* _remotepath;
    long int _currentsize;
    long int _size;
    int _type;
    int _id;
    BOOL _state;
    BOOL _error;
    BOOL _done;
}

- initWithFile: (File*) file;
- initWithName: (NSString*) name withSize: (long int) size withType: (int) type;
- initWithName: (NSString*) name withSize: (long int) size withType: (int) type withLink : (NSString*) link;

- (long int) getID;
- (void) setID: (long int) mid;
- (NSString*) name;
- (NSString*) link;
- (NSString*) remotepath;
- (NSString*) localpath;
- (void) setLocalPath: (NSString*) localpath;
- (void) setRemotePath: (NSString*) remotepath;
- (long int) currentsize;
- (long int) size;
- (NSString*) printsize;
- (NSString*) printcurrentsize;

- addToSize : (long int) size;
- (double) getAdvance;
- (NSString*) getStatus;
- (void) setDone;
- (void) setCurrent: (BOOL) state;
- (void) setError;
- (BOOL) isCurrent;
- (BOOL) isDone;
- (BOOL) isDir;
- (BOOL) isLink;

- (void) print;

@end

