/* -*- C++ -*-
 
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <NewGraphWindow.h>

#include <Setup.h>
#include <Strings.h>
#include <SmithView.h>
#include <MainWindow.h>

#include <qlabel.h>
#include <qlayout.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qapplication.h>

#include <iostream>

//----------------------------------------------------------------------------
NewGraphWindow::NewGraphWindow( QWidget* parent, const char* name )
    : QDialog(parent, name, TRUE),
    topLayout_(0),
    graphName_(0),
    graphType_(0)
{
  setCaption( name );

  topLayout_ = new QVBoxLayout( this );
  QGridLayout* gridLayout = new QGridLayout ( 0 );
  QHBoxLayout* buttonLayout = new QHBoxLayout( 0 );

  topLayout_->addSpacing( 10 );
  topLayout_->addItem( gridLayout );
  topLayout_->addSpacing( 10 );
  topLayout_->addItem( buttonLayout );

  QString okLabel = Strings::translate( Strings::LabelOk );
  QString cancelLabel = Strings::translate( Strings::LabelCancel );
  QPushButton* ok = new QPushButton( okLabel, this );
  QPushButton* cancel = new QPushButton( cancelLabel, this );

  buttonLayout->addWidget( ok );
  buttonLayout->addWidget( cancel );

  connect ( ok, SIGNAL( clicked() ),
            this, SLOT( ok() ) );
  connect ( cancel, SIGNAL( clicked() ),
            this, SLOT( cancel() ) );

  QString nameLabelText = Strings::translate( Strings::LabelGraphName);
  QString typeLabelText = Strings::translate( Strings::LabelGraphType);

  gridLayout->expand( 4, 2 );
  gridLayout->addColSpacing( 0, 30 );
  gridLayout->addColSpacing( 1, 100 );
  gridLayout->addColSpacing( 2, 10 );
  gridLayout->addColSpacing( 3, 100 );
  gridLayout->addColSpacing( 4, 30 );

  for ( uint i=0; i<2; i++ )
    {
      gridLayout->addRowSpacing( i, 35 );
    }

  QLabel* nameLabel = new QLabel( nameLabelText, this );
  graphName_ = new QLineEdit( this );
  gridLayout->addWidget( nameLabel, 0, 1 );
  gridLayout->addWidget( graphName_, 0, 3 );

  QLabel* typeLabel = new QLabel( typeLabelText, this );
  graphType_ = new QComboBox( this );
  gridLayout->addWidget( typeLabel, 1, 1 );
  gridLayout->addWidget( graphType_, 1, 3 );

  QString graphTypeText
  = Strings::translate( Strings::LabelRectangleGraphType);
  QString smithTypeText
  = Strings::translate( Strings::LabelSmithGraphType);
  QString tableTypeText
  = Strings::translate( Strings::LabelTableGraphType);

  graphType_->insertItem( graphTypeText, graphType );
  graphType_->insertItem( smithTypeText, smithType );
  graphType_->insertItem( tableTypeText, tableType );

  resize( topLayout_->sizeHint() );
}

//----------------------------------------------------------------------------
NewGraphWindow::~NewGraphWindow()
{
  delete topLayout_;
}

//----------------------------------------------------------------------------
void NewGraphWindow::ok()
{
  QString name = graphName_->text();
  name = name.upper();
  if ( name.isEmpty() )
    {
      return;
    }
  NewGraphWindow::GraphType graphType
  = (NewGraphWindow::GraphType)graphType_->currentItem();
  MainWindow::instance()->addGraph( name, graphType );
  close();
}

//----------------------------------------------------------------------------
void NewGraphWindow::cancel()
{
  close();
}

