/*  $Id: gnome-app.cpp,v 1.4 2005/03/13 04:03:26 sarrazip Exp $
    gtk-app.cpp - GTK+ application main function

    verbiste - French conjugation system
    Copyright (C) 2003-2005 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

#include "main-window.h"

#include <libintl.h>
#include <locale.h>
#include <libgnomeui/libgnomeui.h>
#include <stdlib.h>

using namespace std;


static
struct poptOption options[] =
{
    {
	NULL,
	'\0',
	0,
	NULL,
	0,
	NULL,
	NULL
    }
};


static
poptContext
get_poptContext(GnomeProgram *program)
{
    GValue value = { 0, };
    g_value_init(&value, G_TYPE_POINTER);
    g_object_get_property(G_OBJECT(program),
			    GNOME_PARAM_POPT_CONTEXT, &value);
    return (poptContext) g_value_get_pointer(&value);
}


int
main(int argc, char *argv[])
{
    bindtextdomain(GETTEXT_PACKAGE, GNOMELOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);

    GnomeProgram *program = gnome_program_init(
			PACKAGE, VERSION, LIBGNOMEUI_MODULE, argc, argv,
			GNOME_PARAM_POPT_TABLE, options,
			GNOME_PARAM_APP_DATADIR, DATADIR,
			NULL);
    gnome_window_icon_set_default_from_file(GNOMEICONDIR "/" PACKAGE ".png");

    poptContext pctx = get_poptContext(program);
    /*const char **args =*/ poptGetArgs(pctx);
    poptFreeContext(pctx);

    hideOnDelete = FALSE;
    try
    {
	initVerbDict();
    }
    catch(logic_error &e)
    {
	showErrorDialog(PACKAGE_FULL_NAME + string(": ") + e.what());
	return EXIT_FAILURE;
    }

    processText("");  // force the result window to be initially displayed
    gtk_main();
    return EXIT_SUCCESS;
}
