#ifndef __TXTBITMAP_H
#define __TXTBITMAP_H

#include <vdr/osdbase.h>
#include <vdr/osd.h>
#include "display.h"

class cTxtBitmap : public cBitmap {
 private:
  eDvbColor bgColor;
  eDvbColor fgColor;
  int origFg, origBg;
  eDvbColor TranslateColor(int color);
  int Language;
  unsigned char LangChar(unsigned char);
  int osdWidth;
  int osdHeight;
  int bpp;
  void IndexBitmap(cBitmap *bitmap, int depth);
 public:
  cTxtBitmap(int, int, int, /*int oWidth, int oHeight,*/ bool);
  virtual ~cTxtBitmap();
  int Bpp() { return bpp; }
  void SetFGColor(int Color);
  void SetBGColor(int Color);
  void SetLanguage(int lang);
  void SetChar(int , int , unsigned char , bool , bool , bool );
  void GenOsdBitmap(char * zeichen, cBitmap * bitmap);
  void ExchangeColor(void);
  virtual void Display(DisplayMode mode, int Offset = -1, eDvbColor FgColor = clrWhite, eDvbColor BgColor = clrBackground);
  void DisplayClock(cBitmap *clockBitmap);
  cBitmap *ScaleBitmap(cBitmap* oldBitmap, int depth, int x0, int y0, int walt, int halt, int wneu, int hneu);
};

#endif //__TXTBITMAP_H
