#include <vdr/interface.h>

#include "txtbitmap.h"
#include "menu.h"
#include "txtfont.h"
#include "setup.h"

cTxtBitmap::cTxtBitmap(int Width, int Height, int Bpp, /*int oWidth, int oHeight, */bool ClearWithBackground = true)
:cBitmap(Width, Height, Bpp, ClearWithBackground)
/* osdWidth(oWidth),
 osdHeight(oHeight)*/
{
   origFg=-1;
   origBg=-1;
   bpp=Bpp;
   IndexBitmap(this, bpp);
}

cTxtBitmap::~cTxtBitmap() {
}


void cTxtBitmap::Display(DisplayMode mode, int Offset, eDvbColor, eDvbColor) {
   //int width=DisplayWidth()*cOsd::CellWidth();
   //int height=(DisplayHeight())*cOsd::LineHeight()-Offset;
   int y0=0;
   int h=Height();
   if (mode==HalfUpper || mode==ZoomUpper || mode==HalfLower || mode==ZoomLower) {
      h /= 2;
   }
   if (mode==HalfLower || mode==ZoomLower)
      y0=Width()/2;
   
   cBitmap *bitmap=ScaleBitmap(this, Bpp(),  0, y0,   Width(), h,   DisplayWidth(), DisplayHeight()); //I _am_ a bitmap
   DisplayDrawBitmap(0, Offset, *bitmap);
   DisplayUpdate();
   delete bitmap;
}

void cTxtBitmap::DisplayClock(cBitmap *clockBitmap) {
   float ratioW= ( (float)DisplayWidth() )/( (float)Width() );
   float ratioH= ( (float)DisplayWidth() )/( (float)Height() );
   int clockWidth= (int)( ((float)clockBitmap->Width()) * ratioW );
   int clockHeight=(int)( ((float)clockBitmap->Height()) * ratioH );
   cBitmap *bitmap=ScaleBitmap(clockBitmap, 1/*bpp*/, 0, 0, clockBitmap->Width(), clockBitmap->Height(),
                               clockWidth, clockHeight);
   DisplayDrawBitmap(DisplayWidth()-bitmap->Width(), 0, *bitmap);
   DisplayUpdate();
   delete bitmap;
}

//what's the C library's function for this?
//#define ROUND(x) ( x-((float)((int)x)) >=0.5 ? ((int)x)+1 : (int)x  )
#define ROUND(x) x

//returns a new bitmap created on the heap with dimensions wneu x hneu, 
//and fills it with a scaled part of oldbitmap, starting at (x0|y0), width walt, height halt.
//Uses a very simple scaling algorithm. 
cBitmap *cTxtBitmap::ScaleBitmap(cBitmap* oldBitmap, int depth, int x0, int y0, int walt, int halt, int wneu, int hneu) {
   int W=oldBitmap->Width();
   int H=oldBitmap->Height();
   if (x0+walt>W) //parameters wrong, cut back to picture size
      walt=W-x0;
   if (y0+halt>H)
      halt=H-y0;
   if (halt==0 || walt==0)
      return 0;
   //float ratioH= ((float)hneu)/((float)halt);
   //float ratioW= ((float)wneu)/((float)walt);
   cBitmap *bitmap=new cBitmap(wneu, hneu, depth);
   IndexBitmap(bitmap, depth);
   
   int/*float*/ oldX=0, oldY=0;
   for (float x=0;x<wneu;x++)
      for (float y=0;y<hneu;y++) {
         //mathematically: Index_neu(x,y) = Index_alt(x0+ratioW*x, y0+ratioH*y)
         //oldX=ratioW*x;
         //oldY=ratioH*y;
         oldX=(int)(((walt*10000/wneu)*x/10000));
         oldY=(int)(((halt*10000/hneu)*y/10000));
         bitmap->SetIndex((int)x,(int)y,*(oldBitmap->Data(ROUND(oldX)+x0, ROUND(oldY)+y0)) );
      }
   return bitmap;
         
}

//necessary when scaling/copying: 
//If the indexed order is different between bitmaps, colors will be exchanged
void cTxtBitmap::IndexBitmap(cBitmap *bitmap, int depth) {
   switch (depth) {
   case 1:
      bitmap->Index(COLORMAPPING_BLACK_2);
      bitmap->Index(COLORMAPPING_WHITE_2);
      break;
   case 2:
      //the 3+1 colors for large OSD.
      bitmap->Index(COLORMAPPING_2_COLOR1);
      bitmap->Index(COLORMAPPING_2_COLOR2);
      bitmap->Index(COLORMAPPING_2_COLOR3);
      bitmap->Index(COLORMAPPING_2_COLOR4);
      break;
   case 3://Bpp == 3  => 8 colors
      bitmap->Index(COLORMAPPING_3_COLOR1);
      //Index(clrTransparent);
      bitmap->Index(COLORMAPPING_3_COLOR2);
      bitmap->Index(COLORMAPPING_3_COLOR3);
      bitmap->Index(COLORMAPPING_3_COLOR4);
      bitmap->Index(COLORMAPPING_3_COLOR5);
      bitmap->Index(COLORMAPPING_3_COLOR6);
      bitmap->Index(COLORMAPPING_3_COLOR7);
      //Index(clrBlack);
      bitmap->Index(COLORMAPPING_3_COLOR8);
      break;
   }
}


eDvbColor cTxtBitmap::TranslateColor(int Color)
{
   if (Bpp() == 2) { //4 colors
 switch (Color) {                           //Original teletext color
  case 0: return COLORMAPPING_BLACK_2;   break;    //Black
  case 1: return COLORMAPPING_RED_2;     break;         //Red
  case 2: return COLORMAPPING_GREEN_2;    break;         //Green
  case 3: return COLORMAPPING_YELLOW_2;     break;         //Yellow
  case 4: return COLORMAPPING_BLUE_2;    break;         //Blue
  case 5: return COLORMAPPING_MAGENTA_2;     break;         //Magenta
  case 6: return COLORMAPPING_CYAN_2;    break;         //Cyan
  case 7: return COLORMAPPING_WHITE_2;    break;         //White
  default:
          return COLORMAPPING_BLACK_2;             //Black
  }
   } else { //8 colors
 switch (Color) {                                       //Original teletext color
  case 0:  return COLORMAPPING_BLACK_3;   break;         //Black
  case 1:  return COLORMAPPING_RED_3;     break;         //Red
  case 2:  return COLORMAPPING_GREEN_3;   break;         //Green
  case 3:  return COLORMAPPING_YELLOW_3;  break;         //Yellow
  case 4:  return COLORMAPPING_BLUE_3;    break;         //Blue
  case 5:  return COLORMAPPING_MAGENTA_3; break;         //Magenta
  case 6:  return COLORMAPPING_CYAN_3;    break;         //Cyan
  case 7:  return COLORMAPPING_WHITE_3;   break;         //White
  case 8:  return COLORMAPPING_INVERTEDBLACK_2;    break;         //Black
  case 9:  return COLORMAPPING_INVERTEDRED_2;      break;         //Red
  case 10: return COLORMAPPING_INVERTEDGREEN_2;    break;         //Green
  case 11: return COLORMAPPING_INVERTEDYELLOW_2;   break;         //Yellow
  case 12: return COLORMAPPING_INVERTEDBLUE_2;     break;         //Blue
  case 13: return COLORMAPPING_INVERTEDMAGENTA_2;  break;         //Magenta
  case 14: return COLORMAPPING_INVERTEDCYAN_2;     break;         //Cyan
  case 15: return COLORMAPPING_INVERTEDWHITE_2;    break;         //White
  default:
          return COLORMAPPING_BLACK_3;                   //Black
  }
    }
}

void cTxtBitmap::SetLanguage(int lang)
{
 Language=lang;
}

unsigned char cTxtBitmap::LangChar(unsigned char Eingabe)
{
 unsigned char Rueckgabe;
 Rueckgabe=Eingabe;
 return Rueckgabe;
}

void cTxtBitmap::SetFGColor(int Color)
{
 origFg=Color;
 fgColor=TranslateColor(Color);
 if ( (fgColor == bgColor) && (origBg != origFg)) {
   Color += 8;
   fgColor=TranslateColor(Color);
 }
}

void cTxtBitmap::SetBGColor(int Color)
{
 bgColor=TranslateColor(Color);
 origBg=Color;
}

void cTxtBitmap::ExchangeColor(void)
{
 eDvbColor Helpcolor;
 Helpcolor=fgColor;
 fgColor=bgColor;
 bgColor=Helpcolor;
 fgColor=TranslateColor(origBg);
 bgColor=TranslateColor(origFg);
}

void cTxtBitmap::SetChar(int x, int y, unsigned char zeich, bool gr_mode, bool double_mode, bool mask_mode)
{
 unsigned int myfont[10];
 unsigned int Ergebnis;

 unsigned int used_zeich;
 int multiplikator;
 eDvbColor farbe;

 used_zeich=LangChar(zeich);

 if (gr_mode==true) {
  if ((zeich>=0x20)&&(zeich<=0x3F)) used_zeich=used_zeich+0x80;
  if ((zeich>=0x60)&&(zeich<=0x7F)) used_zeich=used_zeich+0xA0;
 }
 
 //kopiere mir den Font heraus
 //char str[2]; str[0]=(char)used_zeich; str[1]=0;
 //printf(str);
 used_zeich=used_zeich-0x20;

 for (int i=0;i<10;i++)
  {
   myfont[i]=TXT_Font[used_zeich][i];
   if (mask_mode==true)
    myfont[i]=myfont[i]&TXT_Mask[i];
  }

 if (double_mode==true)
  multiplikator=4;
 else
  multiplikator=2;

 int txt_x_offset=0;
 int txt_y_offset=0;

 for (int yzeich=0;yzeich<10;yzeich++)
  {
  for (int xzeich=0;xzeich<12;xzeich++)
   {
    Ergebnis=(myfont[yzeich]<<xzeich)&0x8000;
    if (Ergebnis>0)
      farbe=fgColor;
    else
      farbe=bgColor;

    for (int i=0;i<multiplikator;i++) {
      SetPixel(txt_x_offset+(x*12)+xzeich,txt_y_offset+(y*10*2)+(yzeich*multiplikator)+i,farbe);
     }
   }
 }

}


void cTxtBitmap::GenOsdBitmap(char * zeichen, cBitmap * bitmap)
{
 char Anzeige;
 int i=0;
 unsigned int Ergebnis;
 unsigned int myfont[10];
 eDvbColor color;

 bitmap->Clear();
 IndexBitmap(bitmap, 1); 

 // paste them into the bitmap
 while ((Anzeige = zeichen[i])!=0x00)
  {
   for (int k=0;k<10;k++)
      myfont[k]=TXT_Font[Anzeige-0x20][k];

   for (int yzeich=0;yzeich<10;yzeich++)
    {
    for (int xzeich=0;xzeich<12;xzeich++)
     {
      Ergebnis=(myfont[yzeich]<<xzeich)&0x8000;
      if (Ergebnis>0)
        color=COLORMAPPING_WHITE_2;
      else
        color=COLORMAPPING_BLACK_2;
        
      bitmap->SetPixel(xzeich+i*12,yzeich*2  ,color);
      bitmap->SetPixel(xzeich+i*12,yzeich*2+1,color);
     }
   }
   i++;
  }
}

