/*
 * teletextosd.c: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: osdteletext.c,v 1.1 2004/10/06 20:30:40 chelli-guest Exp $
 */

#include <vdr/plugin.h>
#include <vdr/i18n.h>
#include <vdr/keys.h>
#include <vdr/config.h>

#include <getopt.h>

using namespace std;

#include "menu.h"
#include "i18n.h"
#include "display.h"
#include "txtrecv.h"
#include "setup.h"

static const char *VERSION        = "0.3.2";
static const char *DESCRIPTION    = "Displays teletext on the OSD";
static const char *MAINMENUENTRY  = "Teletext (OSD)";

class cPluginTeletextosd : public cPlugin {
private:
  // Add any member variables or functions you may need here.
  cTxtStatus *txtStatus;
  ChannelStatus *channelStatus;
  bool startReceiver;
public:
  cPluginTeletextosd(void);
  virtual ~cPluginTeletextosd();
  virtual const char *Version(void) { return VERSION; }
  virtual const char *Description(void) { return tr(DESCRIPTION); }
  virtual const char *CommandLineHelp(void);
  virtual bool ProcessArgs(int argc, char *argv[]);
  virtual bool Start(void);
  virtual void Housekeeping(void);
  virtual const char *MainMenuEntry(void) { return tr(MAINMENUENTRY); }
  virtual cOsdObject *MainMenuAction(void);
  virtual cMenuSetupPage *SetupMenu(void);
  virtual bool SetupParse(const char *Name, const char *Value);
};

class cTeletextSetupPage;
class ActionEdit {
   public:
      void Init(cTeletextSetupPage*, int, cMenuEditIntItem  *, cMenuEditStraItem *);
      cMenuEditStraItem *action;
      cMenuEditIntItem  *number;
      bool visible;
   };
   
class cTeletextSetupPage : public cMenuSetupPage {
friend class ActionEdit;
private:
   TeletextSetup temp;
   int tempPageNumber[10];
   int tempConfiguredClrBackground; //must be a signed int
protected:
   virtual void Store(void);
   ActionEdit ActionEdits[10];
   virtual eOSState ProcessKey(eKeys Key);
public:
   cTeletextSetupPage(void);
   //~cTeletextSetupPage(void);
   //void SetItemVisible(cOsdItem *Item, bool visible, bool callDisplay=false);
};


/*class MenuEditActionItem : public cMenuEditStraItem {
public:
   MenuEditActionItem(cTeletextSetupPage *parentMenu, cMenuEditIntItem *pageNumberMenuItem,
                           const char *Name, int *Value, int NumStrings, const char * const *Strings);
protected:
   virtual eOSState ProcessKey(eKeys Key);
   cTeletextSetupPage *parent;
   cMenuEditIntItem *pageNumberItem;
};*/



cPluginTeletextosd::cPluginTeletextosd(void)
{
  // Initialize any member variables here.
  // DON'T DO ANYTHING ELSE THAT MAY HAVE SIDE EFFECTS, REQUIRE GLOBAL
  // VDR OBJECTS TO EXIST OR PRODUCE ANY OUTPUT!
  txtStatus=0;
  channelStatus=0;
  startReceiver=false;
}

cPluginTeletextosd::~cPluginTeletextosd()
{
   // Clean up after yourself!
   if (txtStatus)
      delete txtStatus;
   if (channelStatus)
      delete channelStatus;
}

const char *cPluginTeletextosd::CommandLineHelp(void)
{
  // Return a string that describes all known command line options.
  return "  -r,       --receive      receive and store teletext\n"
         "                            (use if you do not load\n"
         "                            the original teletext plugin)\n";
}

bool cPluginTeletextosd::ProcessArgs(int argc, char *argv[])
{
  // Implement command line argument processing here if applicable.
   static struct option long_options[] = {
       { "receive",      no_argument,       NULL, 'r' },
       { NULL }
       };
     
   int chr=getopt_long(argc, argv, "r", long_options, NULL);
   if (chr == 'r')
      startReceiver=true;
   return true;
}

bool cPluginTeletextosd::Start(void)
{
  // Start any background activities the plugin shall perform.
   RegisterI18n(Phrases);
   if (startReceiver)
      txtStatus=new cTxtStatus();
   channelStatus=new ChannelStatus();
   if (ttSetup.OSDheight<=0)	ttSetup.OSDheight=Setup.OSDheight;
   if (ttSetup.OSDwidth<=0)	ttSetup.OSDwidth=Setup.OSDwidth;
  
   return true;
}

void cPluginTeletextosd::Housekeeping(void)
{
  // Perform any cleanup or other regular tasks.
}

cOsdObject *cPluginTeletextosd::MainMenuAction(void)
{
   // Perform the action when selected from the main VDR menu.
   return new TeletextBrowser(txtStatus);
}

cMenuSetupPage *cPluginTeletextosd::SetupMenu(void)
{
  // Return a setup menu in case the plugin supports one.
  return new cTeletextSetupPage;
}

bool cPluginTeletextosd::SetupParse(const char *Name, const char *Value)
{
  // Parse your own setup parameters and store their values.
  //Stretch=true;
  if (!strcasecmp(Name, "configuredClrBackground")) ttSetup.configuredClrBackground=( ((unsigned int)atoi(Value)) << 24);
  else if (!strcasecmp(Name, "Action_kRed")) ttSetup.mapKeyToAction[0]=(eTeletextAction)atoi(Value);
  else if (!strcasecmp(Name, "Action_kGreen")) ttSetup.mapKeyToAction[1]=(eTeletextAction)atoi(Value);
  else if (!strcasecmp(Name, "Action_kYellow")) ttSetup.mapKeyToAction[2]=(eTeletextAction)atoi(Value);
  else if (!strcasecmp(Name, "Action_kBlue")) ttSetup.mapKeyToAction[3]=(eTeletextAction)atoi(Value);
  else if (!strcasecmp(Name, "Action_kPlay")) ttSetup.mapKeyToAction[4]=(eTeletextAction)atoi(Value);
  else if (!strcasecmp(Name, "Action_kPause")) ttSetup.mapKeyToAction[5]=(eTeletextAction)atoi(Value);
  else if (!strcasecmp(Name, "Action_kStop")) ttSetup.mapKeyToAction[6]=(eTeletextAction)atoi(Value);
  else if (!strcasecmp(Name, "Action_kRecord")) ttSetup.mapKeyToAction[7]=(eTeletextAction)atoi(Value);
  else if (!strcasecmp(Name, "Action_kFastFwd")) ttSetup.mapKeyToAction[8]=(eTeletextAction)atoi(Value);
  else if (!strcasecmp(Name, "Action_kFastRew")) ttSetup.mapKeyToAction[9]=(eTeletextAction)atoi(Value);
  else if (!strcasecmp(Name, "showClock")) ttSetup.showClock=atoi(Value);
  else if (!strcasecmp(Name, "suspendReceiving")) ttSetup.suspendReceiving=atoi(Value);
  else if (!strcasecmp(Name, "autoUpdatePage")) ttSetup.autoUpdatePage=atoi(Value);
  else if (!strcasecmp(Name, "OSDheight")) ttSetup.OSDheight=atoi(Value);
  else if (!strcasecmp(Name, "OSDwidth")) ttSetup.OSDwidth=atoi(Value);
  else 
     return false;
  return true;
}

void cTeletextSetupPage::Store(void) {
   //copy table
   for (int i=0;i<10;i++) {
      if (temp.mapKeyToAction[i] > LAST_ACTION) //jump to page selected
         ttSetup.mapKeyToAction[i]=(eTeletextAction)tempPageNumber[i];
      else //one of the other modes selected
         ttSetup.mapKeyToAction[i]=temp.mapKeyToAction[i];
   }
   ttSetup.configuredClrBackground=( ((unsigned int)tempConfiguredClrBackground) << 24);
   ttSetup.showClock=temp.showClock;
   ttSetup.suspendReceiving=temp.suspendReceiving;
   ttSetup.autoUpdatePage=temp.autoUpdatePage;
   ttSetup.OSDheight=temp.OSDheight;
   ttSetup.OSDwidth=temp.OSDwidth;
   
   SetupStore("Action_kRed", ttSetup.mapKeyToAction[0]);
   SetupStore("Action_kGreen", ttSetup.mapKeyToAction[1]);
   SetupStore("Action_kYellow", ttSetup.mapKeyToAction[2]);
   SetupStore("Action_kBlue", ttSetup.mapKeyToAction[3]);
   SetupStore("Action_kPlay", ttSetup.mapKeyToAction[4]);
   SetupStore("Action_kPause", ttSetup.mapKeyToAction[5]);
   SetupStore("Action_kStop", ttSetup.mapKeyToAction[6]);
   SetupStore("Action_kRecord", ttSetup.mapKeyToAction[7]);
   SetupStore("Action_kFastFwd", ttSetup.mapKeyToAction[8]);
   SetupStore("Action_kFastRew", ttSetup.mapKeyToAction[9]);
   SetupStore("configuredClrBackground", (int)(ttSetup.configuredClrBackground >> 24));
   SetupStore("showClock", ttSetup.showClock);
   SetupStore("suspendReceiving", ttSetup.suspendReceiving);
   SetupStore("autoUpdatePage", ttSetup.autoUpdatePage);
   SetupStore("OSDheight", ttSetup.OSDheight);
   SetupStore("OSDwidth", ttSetup.OSDwidth);
}


cTeletextSetupPage::cTeletextSetupPage(void) {
   //init tables
   for (int i=0;i<10;i++) {
      if (ttSetup.mapKeyToAction[i] > LAST_ACTION ) {//jump to page selected  
         tempPageNumber[i]=ttSetup.mapKeyToAction[i];
         temp.mapKeyToAction[i]=(eTeletextAction)(LAST_ACTION+1); //to display the last string
      } else { //one of the other modes selected
         temp.mapKeyToAction[i]=ttSetup.mapKeyToAction[i];
         tempPageNumber[i]=100;
      }
   }
   tempConfiguredClrBackground=(ttSetup.configuredClrBackground >> 24);
   temp.showClock=ttSetup.showClock;
   temp.suspendReceiving=ttSetup.suspendReceiving;
   temp.autoUpdatePage=ttSetup.autoUpdatePage;
   temp.OSDheight=ttSetup.OSDheight;
   temp.OSDwidth=ttSetup.OSDwidth;
   
   static const char*modes[4];
   modes[0]=tr("Zoom");
   modes[1]=tr("Half page");
   modes[2]=tr("Change channel");
   modes[3]=tr("Switch background");
   modes[4]=tr("Suspend receiving");
   modes[5]=tr("Jump to...");
   
   Add(new cMenuEditIntItem(tr("Background transparency"), &tempConfiguredClrBackground, 0, 255)); 
   
   Add(new cMenuEditBoolItem(tr("Show clock"), &temp.showClock ));
   
   Add(new cMenuEditBoolItem(tr("Suspend receiving"), &temp.suspendReceiving ));
   
   Add(new cMenuEditBoolItem(tr("Auto-update pages"), &temp.autoUpdatePage ));
   
   Add(new cMenuEditIntItem(tr("OSD height"), &temp.OSDheight, MINOSDHEIGHT, MAXOSDHEIGHT));
   Add(new cMenuEditIntItem(tr("OSD width"), &temp.OSDwidth, MINOSDWIDTH, MAXOSDWIDTH));
   
   
   ActionEdits[0].Init(this, 0, new cMenuEditIntItem(tr("  Page number"), &tempPageNumber[0], 100, 899),
      new cMenuEditStraItem(tr("Red key"),     (int*)&temp.mapKeyToAction[0], LAST_ACTION+2, modes) );
    //Add(tempItem);
    
   ActionEdits[1].Init(this, 1, new cMenuEditIntItem(tr("  Page number"), &tempPageNumber[1], 100, 899),
     new cMenuEditStraItem(tr("Green key"),   (int*)&temp.mapKeyToAction[1], LAST_ACTION+2, modes));
    //Add(tempItem);
    
   ActionEdits[2].Init(this, 2, new cMenuEditIntItem(tr("  Page number"), &tempPageNumber[2], 100, 899),
     new cMenuEditStraItem(tr("Yellow key"),  (int*)&temp.mapKeyToAction[2], LAST_ACTION+2, modes));
    //Add(tempItem);
    
   ActionEdits[3].Init(this, 3, new cMenuEditIntItem(tr("  Page number"), &tempPageNumber[3], 100, 899),
     new cMenuEditStraItem(tr("Blue key"),    (int*)&temp.mapKeyToAction[3], LAST_ACTION+2, modes));
    //Add(tempItem);
    
   ActionEdits[4].Init(this, 4, new cMenuEditIntItem(tr("  Page number"), &tempPageNumber[4], 100, 899),
     new cMenuEditStraItem(tr(cKey::ToString( kPlay)),  (int*)&temp.mapKeyToAction[4], LAST_ACTION+2, modes));
    //Add(tempItem);
    
   ActionEdits[5].Init(this, 5, new cMenuEditIntItem(tr("  Page number"), &tempPageNumber[5], 100, 899),
     new cMenuEditStraItem(tr(cKey::ToString( kPause)),  (int*)&temp.mapKeyToAction[5], LAST_ACTION+2, modes));
    //Add(tempItem);
    
   ActionEdits[6].Init(this, 6, new cMenuEditIntItem(tr("  Page number"), &tempPageNumber[6], 100, 899),
     new cMenuEditStraItem(tr(cKey::ToString(kStop)),  (int*)&temp.mapKeyToAction[6], LAST_ACTION+2, modes));
    //Add(tempItem);
    
   ActionEdits[7].Init(this, 7, new cMenuEditIntItem(tr("  Page number"), &tempPageNumber[7], 100, 899),
     new cMenuEditStraItem(tr(cKey::ToString(kRecord)),  (int*)&temp.mapKeyToAction[7], LAST_ACTION+2, modes));
    //Add(tempItem);
    
   ActionEdits[8].Init(this, 8, new cMenuEditIntItem(tr("  Page number"), &tempPageNumber[8], 100, 899),
     new cMenuEditStraItem(tr(cKey::ToString(kFastFwd)),  (int*)&temp.mapKeyToAction[8], LAST_ACTION+2, modes));
    //Add(tempItem);
    
   ActionEdits[9].Init(this, 9, new cMenuEditIntItem(tr("  Page number"), &tempPageNumber[9], 100, 899),
     new cMenuEditStraItem(tr(cKey::ToString(kFastRew)),  (int*)&temp.mapKeyToAction[9], LAST_ACTION+2, modes));
    //Add(tempItem);
    
}

eOSState cTeletextSetupPage::ProcessKey(eKeys Key) {
   if (Key != kRight && Key!=kLeft) 
      return cMenuSetupPage::ProcessKey(Key);
   cOsdItem *item = Get(Current());
   for (int i=0;i<10;i++) {
      if (ActionEdits[i].action==item) { //we have a key left/right and one of our items as current
         eOSState state = item->ProcessKey(Key);
         if (state != osUnknown) { //really should not return osUnknown I think
            if (temp.mapKeyToAction[i] == (eTeletextAction)(LAST_ACTION+1) && !ActionEdits[i].visible) {
               //need to make it visible
               Ins( ActionEdits[i].number, false, ActionEdits[i+1].action);
               ActionEdits[i].visible=true;
               Display();
            } else if (temp.mapKeyToAction[i] != (eTeletextAction)(LAST_ACTION+1) && ActionEdits[i].visible) {
               //need to hide it
               cList<cOsdItem>::Del(ActionEdits[i].number, false);
               ActionEdits[i].visible=false;
               Display();
            }
            return state;
         }
     }
   }
         
   return cMenuSetupPage::ProcessKey(Key);
}


void ActionEdit::Init(cTeletextSetupPage* s, int num, cMenuEditIntItem  *p, cMenuEditStraItem * a) {
   action=a;
   number=p;
   s->Add(action);
   if (s->temp.mapKeyToAction[num] == (eTeletextAction)(LAST_ACTION+1)) {
      s->Add(number);
      visible=true;
   } else 
      visible=false;
}


/*cTeletextSetupPage::~cTeletextSetupPage(void) {
   hidden.clear();
}

void cTeletextSetupPage::SetItemVisible(cOsdItem *Item, bool visible, bool callDisplay) {
   if (visible) {
      for (list<ItemAndPos>::iterator it=hidden.begin(); it != hidden.end(); ++it) {
         if ( (*it).item==Item ) {
            Ins((*it).item, (*it).position);
            hidden.erase(it);
         }
      }
   } else {
      for (int i=0; i<Count(); i++) {
         if (Get(i)==Item) {
            ItemAndPos iandp;//move to private list
            iandp.item=Item;
            iandp.position=Item->Next(); //store position
            hidden.push_back(iandp);
            cList<cOsdItem>::Del(Item, false); //do _not_ delete
         }
      }
   }
}


MenuEditActionItem::MenuEditActionItem(cTeletextSetupPage *parentMenu, cMenuEditIntItem *pageNumberMenuItem,
                        const char *Name, int *Value, int NumStrings, const char * const *Strings)
   : cMenuEditStraItem(Name, Value, NumStrings, Strings)
{
   parent=parentMenu;
   pageNumberItem=pageNumberMenuItem;
   parent->Add(pageNumberMenuItem);
   parent->SetItemVisible(pageNumberItem, ((*value) == LAST_ACTION+1), false);
}


eOSState MenuEditActionItem::ProcessKey(eKeys Key) {
   eOSState ret=cMenuEditStraItem::ProcessKey(Key);
   if (ret != osUnknown)
      parent->SetItemVisible(pageNumberItem, ((*value) == LAST_ACTION+1), true);
   return ret;
}*/




VDRPLUGINCREATOR(cPluginTeletextosd); // Don't touch this!
