/* Taken from the tetris plugin,
   (c) Clemens Kirchgatterer <clemens@thf.ath.cx> 2002
   
*/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _DISPLAY_H_
#define _DISPLAY_H_

#include <vdr/osd.h>


enum DisplayMode { Full, ZoomUpper, ZoomLower, HalfUpper, HalfLower };

enum Color {
	BGR, RED, GRN, BLU, YEL, MAG, CYN, WHT, BLK, TRS
};

#define configurableBackground DisplayGetBackground()
//mapping now moved to colormapping.h for better configurability
#include "colormapping.h"

int  DisplayOpen(int Bpp, DisplayMode mode);
int  DisplayClose(void);
int  DisplayCheckMode(int Bpp, DisplayMode mode);
int  DisplayWidth(void);
int  DisplayHeight(void);
int  DisplayFontHeight(void);
int  DisplayCharWidth(char c);
int  DisplayStringWidth(const char *s);
eDvbColor DisplayGetBackground();
void DisplaySetBackground(eDvbColor bg);
void DisplayDrawBlock(int x, int y, Color col);
void DisplayDrawRect(int x1, int y1, int x2, int y2, Color col);
void DisplayDrawBitmap(int x, int y, const cBitmap &bitmap);
void DisplayClearBlock(int x, int y);
void DisplayPrintText(int x, int y, const char *txt);
void DisplayMessage(const char *txt);
void DisplayClearMessage();
void DisplayUpdate(void);

#endif
