/* ==================================================== ======== ======= *
 *
 *  uutable.cpp
 *  Ubit Project [Elc::2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uutable.cpp	ubit:03.06.03"
#include <udefs.hpp>
#include <ubrick.hpp>
#include <ucall.hpp>
#include <uerror.hpp>
#include <ustr.hpp>
#include <uctrl.hpp>
#include <ucontext.hpp>
#include <ubox.hpp>
#include <uboxImpl.hpp>
#include <uborder.hpp>
#include <uview.hpp>
#include <uviewImpl.hpp>
#include <ucolor.hpp>
#include <uevent.hpp>
#include <uwin.hpp>
#include <uappli.hpp>
#include <ugraph.hpp>
#include <utable.hpp>
#include <ustyle.hpp>
#include <math.h>
#include <update.hpp>

const int TABLE_CELL_QUANTUM = 15;

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UStyle *UTable::style = null;

const UStyle& UTable::makeStyle() {
  if (!style) {
    style = new UStyle();
    style->viewStyle      = &UTableView::style;
    style->textSeparator  = &ustr("\n");
    //style->local.orient   = UOrient::vertical.get();
    style->orient   = UOrient::HORIZONTAL;  // TST!! ??
    style->local.halign   = UHalign::LEFT;
    style->local.valign   = UValign::TOP;
    style->local.hspacing = 0; //EX 1;
    style->local.vspacing = 1;
    style->local.padding.set(1, 1); //!!EX: 0,0
  }
  return *style;
}

UTable::UTable(const UArgs& a): UBox(a) {}
UTable& utable(const UArgs& a) {return *(new UTable(a));}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UStyle *UTrow::style = null;
const UStyle& UTrow::makeStyle() {
  if (!style) {
    style = new UStyle();
    style->textSeparator  = &ustr("\t");
    style->orient   = UOrient::HORIZONTAL;

    // 6apr02: il faut left car hflex a un resultat imprevu (bug?)
    style->local.halign   = UHalign::LEFT;

    // 6apr02: il faut vflex pour etre conforme a HTML (une utcell
    // devra occuper toute la hauteur d'un utrow (nb: bug corrige
    // dans uuview.cc qui permet d'utilser cette option)
    style->local.valign   = UValign::flex.get();

    style->local.hspacing = 1;
    style->local.vspacing = 0;  //EX 1
    style->local.padding.set(0, 0);
  }
  return *style;
}

//UTrow::UTrow(const UArgs& a): UBox(a) {}
UTrow::UTrow(const UArgs& a): UGroup(a) {}   //TST!!
UTrow& utrow(const UArgs& a) {return *(new UTrow(a));}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UStyle *UTcell::style = null;
const UStyle& UTcell::makeStyle() {
  if (!style) {
    style = new UStyle();
    style->viewStyle      = &UFlowView::style;
    style->orient         = UOrient::HORIZONTAL;  // ??
    style->local.halign   = UHalign::FLEX;
    style->local.valign   = UValign::FLEX;
    style->local.hspacing = 0;  //!!EX 1;
    style->local.vspacing = 0;  //!!EX 1;
    style->local.padding.set(0,0); //EX: 1,1
  }
  return *style;
}

UTcell& utcell(const UArgs& a) {
  return *(new UTcell(a));
}
UTcell& utcell(short colspan, const UArgs& a) {
  return *(new UTcell(colspan, a));
}
UTcell& utcell(short colspan, short rowspan, const UArgs& a) {
  return *(new UTcell(colspan, rowspan, a));
}

UTcell::UTcell(const UArgs& a): UFlowbox(a) {
  colspan = 1;
  rowspan = 1;
}
UTcell::UTcell(short _colspan, const UArgs& a) : UFlowbox(a) {
  colspan = _colspan;
  rowspan = 1;
}
UTcell::UTcell(short _colspan, short _rowspan, const UArgs& a) : UFlowbox(a) {
  colspan = _colspan;
  rowspan = _rowspan;
}

void UTcell::setColspan(short _colspan) {
  colspan = _colspan;
  update(UUpdate::all);
}

void UTcell::setRowspan(short _rowspan) {
  rowspan = _rowspan;
  update(UUpdate::all);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UViewCell* UViewCell::augment(UViewCell *tab, int *count, int span) {
  int quantum = std::max(span, TABLE_CELL_QUANTUM);
  if (!tab) {
    *count = quantum;
    tab = (UViewCell*)malloc(sizeof(UViewCell) * *count);
  }
  else {
    *count += quantum;
    tab = (UViewCell*)realloc(tab, sizeof(UViewCell) * *count);
  }

  if (!tab) UError::error("ViewCell::augment", UError::No_more_memory);
  else for (int k = *count - quantum; k < *count; k++) {
    tab[k].min_dim = tab[k].max_dim = tab[k].spec_dim = 0;
    tab[k].rowspan = tab[k].colspan = 0;
  }
  return tab;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UViewStyle UTableView::style(&UTableView::makeView, UMode::UCONST);

// "static" constructor used by UViewStyle to make a new view
UView* UTableView::makeView(UBoxLink*bl, UView* parview, UWinGraph *wgraph){
  return new UTableView(bl, parview, wgraph);
}

UTableView::~UTableView() {
  if (cols)  free(cols);
  if (lines) free(lines);
}

UTableView::UTableView(UBoxLink *box_link, UView* par_view, UWinGraph *wgraph) 
  : UView(box_link, par_view, wgraph) {
    cmax = lmax = 0;
    cols  = UViewCell::augment(null, &cmax, 1);
    lines = UViewCell::augment(null, &lmax, 1);
    lcur = ccur = ccount = lcount = 0;
}

struct UTableLayoutImpl : public UViewLayoutImpl {
  UTableView &t;
  UTableLayoutImpl(UTableView *v) : UViewLayoutImpl(v), t(*v) {
    t.lcur = t.ccur = t.ccount = t.lcount = 0;
  }
};

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

static void tableDoLayout(UTableLayoutImpl &vd, UContext &curp, 
			  UGroup *grp, UViewLayout &vl);

bool UTableView::doLayout(UContext &parp, UViewLayout &vl) {
  UBox *box = getBox();
  UTableLayoutImpl vd(this);

  vl.spec_w = vl.spec_h = -1;
  vl.cmin_w = vl.cmax_w = 0;
  vl.cmin_h = vl.cmax_h = 0;
  vl.line_h = vl.line_w = 0;

  // !!PREMIER ROUND!!
  vl.strategy = UViewLayout::GET_HINTS;
  UContext curp(box, this, parp);
  tableDoLayout(vd, curp, box, vl);

  // vl.spec_w >=0 means: "table width was explicitely specified"
  // vl.spec_w < 0 means: "table uses as many space as needed"

  if (vl.spec_w < 0) {
    for (int c = 0; c < ccount; c++)  {
      cols[c].spec_dim = cols[c].max_dim;
    }
  }

  else {  // (vl.spec_w >= 0)   la width de la table est specifiee
    // REGLES: cell.uwidth est un 'hint':
    // - cell.w est tjrs >= cell.wmin qqsoit specif. cell.uwidth
    // - cell.w est < cell.uwidth si table.uwidth pas assez grande

    // spec. table.uwidth > max computed witdh ==> agrandir les cells
    if (vl.spec_w >= vl.cmax_w) {
      // 'fill_prop' = coefficient pour fill proportionnel =
      // (fill_w = used - reste_) / reste

      if (vl.cmax_w <= 0) vl.cmax_w = 1; //securite
      float fill_prop = (vl.spec_w - vl.cmax_w) / (float)vl.cmax_w;

      // favorite doit etre le MAX de la taille desiree et de la taille
      // requise par les enfants (sinon le scroll ne marchera pas dans
      // le 1e cas et le 'flex' ne marchera pas dans le second)
      // favoriteWidth = std::max(vl.spec_w, vl.cmax_w);
      // width = vl.spec_w;

      for (int c = 0; c < ccount; c++)  {
	// l'agrandissement est proportionnel au contenu de la cell
	cols[c].spec_dim = 
	  cols[c].max_dim + (u_dim)(cols[c].max_dim * fill_prop);
      }
    }

    // spec. table.uwidth > min computed witdh ==> reduire les cells
    else if (vl.spec_w >= vl.cmin_w) {
      // 'fill_prop' = coefficient pour fill proportionnel =
      // (fill_w = used - reste_) / reste
      if (vl.cmax_w <= 0) vl.cmax_w = 1; //securite

      // !!! A REVOIR: FAIRE PROPORTION PAR RAPPORT AU MAX PAS AU MIN !!!
      // et tenir compte des SPECS
      float fill_prop = (vl.spec_w - vl.cmin_w) / (float)vl.cmin_w;

      for (int c = 0; c < ccount; c++)  {
	// taille min + proportion liee a la taille du max
	//??imposer(vd.cols[c].min_dim + ?? vd.cols[c].max_dim * fill_prop);
	cols[c].spec_dim =
	  cols[c].min_dim + (u_dim)(cols[c].min_dim * fill_prop);
      }
    }

    // spec. table.uwidth < min computed witdh ==> imposer cell.wmin
    else /*(vl.spec_w < vl.wmin)*/ {

      // !ATTENTION: diffs importantes avec hbox/vbox:
      // -- table.w est toujours >= somme{cells.wmin} qqsoit table.uwidth
      //    (==> les enfants ne sont jamais caches par les tables)
      // -- cell.finalw est tjrs >= cell.wmin qqsoit cell.uwidth
      // -- cell.finalw est < cell.uwidth si table.uwidth trop petite
      //
      //favoriteWidth = vl.wmin;

      for (int c = 0; c < ccount; c++)  {
	 cols[c].spec_dim = cols[c].min_dim;
      }
    }

    // ENSUITE faudra voir les pourcentages des cells......!!!!
  }

  //else {
    // la table a une width proportionnelle....!!!
  // ........
  //}

  vd.mustLayoutAgain = false;

  //FAUX: vd.cmax = vd.lmax = 0;
  //FAUX: vd.cols = ViewCell::augment(null, vd.cmax);
  //FAUX: d.lines = ViewCell::augment(null, vd.lmax);

  int k;
  for (k = 0; k < ccount; k++)
    cols[k].min_dim = cols[k].max_dim = 0;  //!PAS tab[k].spec_dim = 0;

  for (k = 0; k < lcount; k++)
    lines[k].min_dim = lines[k].max_dim = 0; //!PAS tab[k].spec_dim = 0;

  ccur = ccount = lcount = 0; //APRES!

  vl.spec_w = vl.spec_h = -1;
  vl.cmin_w = vl.cmax_w = 0;
  vl.cmin_h = vl.cmax_h = 0;
  vl.line_h = vl.line_w = 0;

  // !!DEUXIEME ROUND!!
  vl.strategy = UViewLayout::IMPOSE_WIDTH;
  UContext curp2(box, this, parp);
  tableDoLayout(vd, curp2, box, vl);

  // vd.view->chwidth = std::max(vl.spec_w, vl.cmax_w);
  // vd.view->width = vd.view->chwidth; // chwidth n'est pas la taille des enfants!

  return false;
};

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

static void rowDoLayout(UView *row_view,
			UTableLayoutImpl &vd, UContext &parp, 
			UGroup *grp, UViewLayout &vl);

static void tableDoLayout(UTableLayoutImpl &vd, UContext &curp, 
			  UGroup *grp, UViewLayout &vl) {
  UMultiList mlist(curp, grp, true);  //rescale

  if (curp.local.content) {
    UGroup *content = curp.local.content;
    curp.local.content = null;	// avoid infinite recursion
    tableDoLayout(vd, curp, content, vl);   // pas de curp, meme vd
  }

  // pour chaque ligne
  for (ULink *ch = mlist.first(); ch != null; ch = mlist.next(ch))
    if (ch->verifies(&curp, grp)) {

      UBrick *b = ch->getChild();
      UView *chboxview = null;
      UViewLayout chvl;  //att: reset by constr.
      UGroup *chgrp = null; //!att reinit!

      // UProps
      if (b->propCast()) 
	b->propCast()->putProp(&curp, grp);
      
      // UElems
      else if (b->elemCast()) {
	UError::error("warning@UTable::tableDoLayout",
		      UError::Wrong_table_child, b->cname());
      }

      // UGroups, UBoxes, UWins
      else if ((chgrp = b->groupCast()) && chgrp->isShowable()) {

	if (chgrp->boxCast()) {  //QUE BoxCast

	  if ((chgrp->isDef(0,UMode::BOX)  // UBox ou UWin incrust
	       // this==hardwin && child==softwin :
	       || (mlist.isSoftwinList() && chgrp->isDef(0,UMode::SOFTWIN))
	       )
	      && (chboxview = ((UBoxLink*)ch)->getViewInside(vd.view))
	      ) {

	    if (chgrp->isDef(0, UMode::FLOATING)) {
	      chvl.strategy = vl.strategy;
	      vd.mustLayoutAgain |= chboxview->doLayout(curp, chvl);
	    }

	    else {  // cas normal
	      UError::error("warning@UTable::tableDoLayout", 
			    UError::Wrong_table_child, b->cname());
	    } // end cas normal

	  } // endif(isDef(Mode::BOX) ...)
	} //endif(boxCast)

	else {   // UTrow or UGroup
	  if ((dynamic_cast<UTrow*>(b))) {  //TST!!
	    // agrandir lines;
	    if (vd.t.lcount >= vd.t.lmax) 
	      vd.t.lines = UViewCell::augment(vd.t.lines, &vd.t.lmax, 1);
	  
	    // fonction specifique pour TableRows
	    chvl.strategy = vl.strategy; //!!
	    rowDoLayout(null, vd, curp, chgrp, chvl);
	    vd.t.lcount++;
	  }

	  else {   // just an UGroup
	    UContext chcurp(chgrp, vd.view, curp);
	    tableDoLayout(vd, chcurp, chgrp, vl);  //own curp, same vd
	  }
	}
      }
    }

  // la suite ne concerne pas les UGroup
  if (grp->boxCast()) {
    // a la ligne final
    // Les UTable COMMENCENT et se TERMINENT par un alaligne! A COMPTER!!
    // alaligne(vl, curp);

    UMargins margins(0, 0, 0, 0);
    if (curp.local.border) {
      curp.local.border->getSize(curp, margins); // !! A ETENDRE !!
    }

    vl.spec_w = curp.local.width;  // redefini ensuite dans computeWidth
    // prendre en compte les spacings (mais pas les borders rajoutes ensuite)
    vl.cmax_w = vl.cmin_w = curp.local.hspacing * (vd.t.ccount - 1);
    /*
    vl.cmax_w = vl.cmin_w =
      margin.left + margin.right	// borders
      + curp.local.padding.left + curp.local.padding.right
      + curp.local.hspacing * (vd.t.ccount - 1); // total spacing between colums 
    */

    vl.spec_h = curp.local.height;  // redefini ensuite dans computeHeight
    // prendre en compte les spacings (mais pas les borders rajoutes ensuite)
    vl.cmin_h = vl.cmax_h = curp.local.vspacing * (vd.t.lcount - 1);

    for (int c = 0; c < vd.t.ccount; c++)  {
      vl.cmin_w += vd.t.cols[c].min_dim;
      vl.cmax_w += vd.t.cols[c].max_dim;
    }

    for (int l = 0; l < vd.t.lcount; l++)  {
      vl.cmin_h += vd.t.lines[l].min_dim;
      vl.cmax_h += vd.t.lines[l].max_dim;
    }

    // NB: vd.children_h ne doit pas prendre en compte les borders
    // vd.children_h = U_STD::MAX(curp2.local.height, vl.cmax_h); ????
    vd.children_w = vl.cmax_w;
    vd.children_h = vl.cmax_h;

    // arg opt. true => les cmin/cmax sont deja definis 
    // (seulement leur rajouter les borders)
    vd.computeWidth(curp, margins, vl, true);
    vd.computeHeight(curp, margins, vl, true);
  }
} 

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

static int setHintSizes(UView *chboxview, UContext &curp, 
			int colspan, int rowspan, 
			UTableLayoutImpl &vd, UViewLayout &chvl) {

  chvl.strategy = UViewLayout::GET_HINTS;

  if (dynamic_cast<UFlowView*>(chboxview))
    ((UFlowView*)chboxview)->getHints(curp, chvl);  // init. chvl
  else
    chboxview->doLayout(curp, chvl);  // init. chvl

  vd.t.cols[vd.t.ccur].colspan = colspan;
  int cmin_w = (int)rint((double)chvl.cmin_w / colspan);
  int cmax_w = (int)rint((double)chvl.cmax_w / colspan);
  int spec_w = (int)rint((double)chvl.spec_w / colspan);

  for (int colk = vd.t.ccur; colk < vd.t.ccur+colspan; colk++) {
    // col width
    vd.t.cols[colk].min_dim  = std::max(vd.t.cols[colk].min_dim, cmin_w);
    vd.t.cols[colk].max_dim  = std::max(vd.t.cols[colk].max_dim, cmax_w);
    vd.t.cols[colk].spec_dim = std::max(vd.t.cols[colk].spec_dim, spec_w);
  }

  vd.t.cols[vd.t.ccur].rowspan = rowspan;
  int cmin_h = (int)rint((double)chvl.cmin_h / rowspan);
  int cmax_h = (int)rint((double)chvl.cmax_h / rowspan);
  int spec_h = (int)rint((double)chvl.spec_h / rowspan);

  // line height
  vd.t.lines[vd.t.lcount].min_dim  = std::max(vd.t.lines[vd.t.lcount].min_dim, cmin_h);
  vd.t.lines[vd.t.lcount].max_dim  = std::max(vd.t.lines[vd.t.lcount].max_dim, cmax_h);
  vd.t.lines[vd.t.lcount].spec_dim = std::max(vd.t.lines[vd.t.lcount].spec_dim, spec_h);

  return chvl.cmax_w;   //inutile dans le cas GET_HINT?
}

/* ==================================================== ======== ======= */

static int setImposedSizes(UView *chboxview, UContext &curp, 
			   int colspan, int rowspan,
			   UTableLayoutImpl &vd, UViewLayout &chvl) {
  chvl.spec_w = 0;
  for (int colk = vd.t.ccur; colk < vd.t.ccur+colspan; colk++) {
    chvl.spec_w += vd.t.cols[colk].spec_dim;
  }

  chvl.strategy = UViewLayout::IMPOSE_WIDTH;
  chboxview->doLayout(curp, chvl);

  vd.t.cols[vd.t.ccur].colspan = colspan;
  int cmax_w = (int)rint((double)chvl.cmax_w / colspan);

  for (int colk = vd.t.ccur; colk < vd.t.ccur+colspan; colk++) {
    //!att: min pas calcule, max = taille trouvee
    // et !!calcul different du cmax_w dans le UFlowbox
    vd.t.cols[colk].max_dim = std::max(vd.t.cols[colk].max_dim, cmax_w);
  }

  vd.t.cols[vd.t.ccur].rowspan = rowspan;
  int cmax_h = (int)rint((double)chvl.cmax_h / rowspan);

  vd.t.lines[vd.t.lcount].max_dim = std::max(vd.t.lines[vd.t.lcount].max_dim, cmax_h);

  return chvl.cmax_w;
}

/* ==================================================== ======== ======= */

//!! curp pas parp!
static void rowDoLayout(UView *row_view, UTableLayoutImpl &vd,
			UContext &parp, UGroup *grp, UViewLayout &vl) {
  // soit le row est un UBox et il a sa propre view soit c'est un UGroup
  // et il utilise celle de la table
  if (!row_view) row_view = vd.view;
  UContext curp(grp, row_view, parp);
  UMultiList mlist(curp, grp, true);  //rescale

  /* EX:
  if (dynamic_cast<UTrow*>(grp)) {  //TST!!
    vd.t.ccur = 0; //que pour les URow !!!
    vl.line_w = 0;
  }
  */
  vd.t.ccur = 0; //!!!
  vl.line_w = 0;

  for (ULink *ch = mlist.first(); ch != null; ch = mlist.next(ch))
    if (ch->verifies(&curp, grp)) {
	
      UBrick *b = ch->getChild();
      UView *chboxview = null;
      UGroup *chgrp = null; //!att reinit!
      UViewLayout chvl; //att: reinit by constr.

      // UProps
      if (b->propCast())  
	b->propCast()->putProp(&curp, grp);

      // UElems
      else if (b->elemCast()) {
	/* normalement interdits
	   b->elemCast()->getSize(&curp, &chw, &chh);
	   vd.children_w += chw;
	   if (ch->next()) vd.children_w += curp.local.hspacing; //FAUX!
	   if (chh > vd.children_h) vd.children_h = chh;  //=STD::MAX()
	*/
	UError::error("warning@UTrow::doLayout", 
		      UError::Wrong_row_child, b->cname());
      }

      // UGroups, UBoxes, UWins
      else if ((chgrp = b->groupCast()) && chgrp->isShowable()) {

	if (chgrp->boxCast()) {  // QUE boxCast

	  if ((chgrp->isDef(0,UMode::BOX)  // UBox ou UWin incrust
	       // this==hardwin && child==softwin :
	       || (mlist.isSoftwinList() && chgrp->isDef(0,UMode::SOFTWIN))
	       )
	      && (chboxview = ((UBoxLink*)ch)->getViewInside(row_view))
	      ) {

	    if (chgrp->isDef(0, UMode::FLOATING)) {
	      chvl.strategy = vl.strategy;
	      vd.mustLayoutAgain |= chboxview->doLayout(curp, chvl);
	    }

	    else {  // cas normal
	      int colspan = 1;  //default
	      int rowspan = 1;

	      //cas des UTcell: peuvent avoir un colspan et un rowspan
	      UTcell *cell = dynamic_cast<UTcell*>(b);
	      if (cell) {
		colspan = cell->getColspan();
		rowspan = cell->getRowspan();
	      }

	      // agrandir cols (bug corrige 3aug02: etait mal place)
	      if (vd.t.ccur + colspan > vd.t.cmax) 
		vd.t.cols = UViewCell::augment(vd.t.cols, &vd.t.cmax, colspan);
	  	  
	      // tenir compte des rowspan des lignes precedentes
	      if (vd.t.cols[vd.t.ccur].rowspan > 1) {
		(vd.t.cols[vd.t.ccur].rowspan)--;
		vd.t.ccur += vd.t.cols[vd.t.ccur].colspan;
	      }

	      if (vl.strategy == UViewLayout::GET_HINTS) {
		// obtenir taille souhaitee
		vl.line_w += setHintSizes(chboxview, curp, 
					  colspan, rowspan, vd, chvl);
	      }
	      
	      else if (vl.strategy == UViewLayout::IMPOSE_WIDTH) {
		// imposer taille
		//int ccur = vd.t.ccur;
		vl.line_w += setImposedSizes(chboxview, curp, 
					     colspan, rowspan, vd, chvl);
	      }

	      else UError::error("internal@UTrow::doLayout", 
				 "wrong ViewLayout mode");
	  
	      // passer a la Nieme colonne suivante
	      vd.t.ccur += colspan;
	    } // end cas normal
	  } // endif(isDef(Mode::BOX) ...)
	} //endif(boxCast)
	    
	// just an UGroup
	else {
	  UContext chcurp(chgrp, row_view, curp);
	  // rowDoLayout(/*row_view,*/ chgrp, bug? curp, vd, vl);
	  rowDoLayout(null, vd, chcurp, chgrp, vl);//own curp, same vd
	}
      }
    }
  
  // ccount = MAX de c pour chaque ligne
  vd.t.ccount = std::max(vd.t.ccount, vd.t.ccur);
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */

