/* ==================================================== ======== ======= *
 *
 *  uedit.hpp
 *  Ubit Project  [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _uedit_hpp_
#define	_uedit_hpp_
//pragma ident	"@(#)uedit.hpp	ubit:03.05.05"
#include <ubit/uprop.hpp>


/** make a Container object editable.
 * exemple: 
 * <pre>
 *   UStr& str = ustr("abcd");
 *   UBox& box = ubox(uedit() + str);
 * </pre>
 * will make string 'str' editable inside container 'box'
 */
class UEdit : public UProp {
public:
  UEdit(bool is_editable = true);
  virtual ~UEdit();   // necessaire car removingFrom specifique

  friend UEdit &uedit(bool is_editable = true) {return *(new UEdit(is_editable));}
  ///< creator shortcut (same as *new UEdit()).

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  void setEditable(bool = true);
  bool isEditable() const;
  
  const UStr *getCaretStr() const;
  const UStr *getCaretStr(int& pos) const;
  /**< returns the UStr that contains the caret and the position of the caret in this string.
   * Notes: 
   * - returns null if the caret is not set
   * - a Box can contain several UStr. The returned position
   *   is relative to the string that contains the caret
    */

  void setCaretStr(UStr*, int pos);
  /**< sets the UStr that contains the caret and the position of the caret in this string.
   * Notes:
    * - pos = 0 means beginning of string; pos = -1 end of string
    * - a Box can contain several UStr. The position is relative to the string
    *   that contains the caret (ie. the fisrt arg. of setCaretStr)
    * - this UStr must be in the same Box as the UEdit
    */

  UStr* getPreviousStr(UGroup* par) const;
  UStr* getNextStr(UGroup* par) const;

  virtual void update();

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // implementation

  bool nextChar(UGroup* par, bool update_views, bool is_flowview);
  bool previousChar(UGroup* par, bool update_views, bool is_flowview);
  void deletePreviousChar(UGroup* par, bool update_views, bool is_flowview);
  void deleteChar();
  void setCaretStr(UStr*, int pos, bool update_view, bool no_scrolling);

  UEdit& enableReturn(bool = true) {return *this;}
  ///< OBSOLETE, no effect.

#ifndef NO_DOC

  virtual void putProp(class UContext*, class UCtrl*);
  virtual void addingTo(class ULink *selflink, UGroup *parent);
  virtual void removingFrom(class ULink *selflink, UGroup *parent);
  ///< NOTE that this function require a specific destructor.

  /// prototypes for non-warped text (UView)
  virtual int getXpos(class UWinGraph&, class UContext*, 
		      const URegion& r) const;
  virtual void paint(class UWinGraph&, class UContext*, 
		     const URegion &r) const;

  /// prototypes for warped text (UFlowView)
  virtual int getXpos(class UWinGraph&, class UContext*, const URegion& r,
		      int offset, int cellen) const;
  virtual void paint(class UWinGraph&, class UContext*, const URegion &r, 
		     int offset, int cellen) const;

private:
  uptr<UStr> caret_str;  // the string that contains the caret (if any)
  uptr<UCall>calls;      // callback object
  int caret_pos;         // the position of the caret in 'caret_str'
  bool is_editable;
  void callbacks(UEvent&);
  void kpressed(UEvent&);
  void mpressed(UEvent&);
  void mreleased(UEvent&);
#endif
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
