<?php
/**
 * Copyright 2002 - 2003 by Gero Kohnert
 *
 * @modulegroup ldap
 * @module ldap_import
 * @package ldap
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("ldap","ins");
 loadmodule("ldap");
 loadmodule("file");

 $gotourl = "ldap/ldap_show.php";
 $msg = "";
 $import = array();
 $l = new ldap($dbconn);

 if ( isset($_POST['sv']) ) {
   $l->setserver(StripSlashes($_POST['sv']));
   $gotourl= addUrlParameter($gotourl,"sv=". $_POST['sv']);
 }
 if ( isset($_POST['host']) && isset($_POST['port'])) {
   $l->sethost(StripSlashes($_POST['host']),$_POST['port']);
   $gotourl= addUrlParameter($gotourl,"host=". UrlEncode($l->host));
   $gotourl= addUrlParameter($gotourl,"port=". UrlEncode($l->port));
 }

 if ($l->host == "") {
   $msg .= "NO Server defined !";
 }


 if ( ($msg == "") && ! $l->connect() ) {
   $msg .= $lang['LDAP_Err001'];
 }
 if ( !isset($_POST['key']) ) {
   $msg .= "missing ldap key";
 } else {
   $key = StripSlashes($_POST['key']);
   $gotourl= addUrlParameter($gotourl,"key=". UrlEncode($key));
 }

 if ($msg == "" ) {
   $dbconn->Begin("WORK");
   $adr = $l->import($key);
   $dbconn->Commit("WORK");
   if ($adr != -1) {
     $gotourl = $adr->getUrl();
   }
 }
 $gotourl = addSessionKey($gotourl);
 $_SESSION['MSGID'.strlen($msg)] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". strlen($msg));
 Header("Status: 302 Moved Temporarily");
 Header("Location: ". dirname(getBaseUrl()) ."/". $gotourl);

 $l->close();
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: ldap_import.php,v 1.5.2.1 2003/08/14 19:14:59 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>
