<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup department
 * @module department_new
 * @package department
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("department","new");
 loadlayout();

 /**
  * change/modify a company
  */
 class department_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $tutos,$lang,$table;

     if ( $this->loc != "" ) {
       echo "<form name=\"locadd\" action=\"location_ins.php\" method=\"post\">\n";
     } else {
       echo "<form name=\"depadd\" action=\"department_ins.php\" method=\"post\">\n";
     }
     $this->addHidden("id", $this->obj->id);

     echo $this->DataTableStart();
     echo "<tr>\n";
     if ( $this->obj->id < 0 ) {
       echo " <th colspan=\"5\">". sprintf($lang['DepartmentCreate'])."</th>\n";
     } else {
       echo " <th colspan=\"5\">". sprintf($lang['DepartmentModify'])."</th>\n";
     }
     echo "</tr>\n";
     if ( $this->obj->id > 0 ) {
       echo "<tr>\n";
       echo " <td colspan=\"5\" align=\"right\">". acl_link($this->obj) ."</td>\n";
       echo "</tr>\n";
     }

     echo "<tr>\n";
     echo $this->showfieldc($lang['Department'],1,"name");
     if ( $this->loc != "" ) {
       echo "<td colspan=\"4\">". $this->obj->getLink() ."</td>\n";
       $this->addHidden("d_id", $this->obj->id);
     } else {
       echo "<td colspan=\"4\"><input size=\"30\" maxlength=\"30\" name=\"name\" value=\"". $this->obj->name ."\"></td>\n";
     }
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['Company'],1,"cfn");
     if ( $this->loc != "" ) {
       echo "<td colspan=\"4\">". $this->obj->company->getLink() ."</td>\n";
       $this->addHidden("c_id",$this->obj->company->id);
       $this->addHidden("category",2);
       $this->addHidden("cploc",0);
       $this->addHidden("loc_id",$this->loc->id);
     } else {
       echo "<td colspan=\"4\">\n";
       select_from_array_or_input($this->obj,"c",$this->obj->company,0);
       echo "</td>\n";
     }
     echo "</tr>\n";

     if ( $this->loc == "" ) {
       # References to modules
       module_addforms($this->user,$this->obj,4);
     }

     if ( $this->loc != "" ) {
       $this->loc->inputform($this);
     }

     echo "<tr>\n";
     if ($this->obj->id > 0 ) {
       submit_reset(0,1,1,1,1,1);
     } else {
       submit_reset(0,-1,1,1,1,1);
     }
     echo "</tr>\n";

     echo $this->DataTableEnd();
     echo $this->getHidden();
     hiddenFormElements();
     echo "</form>\n";
     if ( $this->loc != "" ) {
       echo $this->setfocus("locadd.lname");
     } else {
       echo $this->setfocus("depadd.name");
     }

     echo $lang['FldsRequired'] ."\n";
   }
   /**
    * naviagte
    */
   Function navigate() {
     global $lang;

     echo "<tr><td>";

     if ( $this->obj->mod_ok()  ) {
       if ( count($this->obj->loc) ) {
         DoubleTableStart();
         foreach($this->obj->location as $i => $f) {
           echo "<tr><th colspan=\"2\">". sprintf($lang['AdrLocTitle'],$f->lname) ."</th></tr>\n";
           echo "<tr>";
           echo "<td>";
           if ( $f->mod_ok() ) {
             echo menulink("department_new.php?id=". $this->obj->id ."&loc_id=". $f->id,$lang['Change'],sprintf($lang['ChangeLocInfo'],$f->lname, $this->obj->getFullName()));
           } else {
              echo $lang['Change'];
           }
           echo "</td><td>\n";
           if ( $f->del_ok() ) {
             echo confirmlink("location_del.php?ref=". $this->obj->id ."&id=". $f->id,$lang['Delete'],sprintf($lang['DeleteLocInfo'],$f->lname, $this->obj->getFullName()));
           } else {
              echo $lang['Delete'];
           }
           echo "</td>\n";
           echo "</tr>\n";
         }
         DoubleTableEnd();
       }
       if ( $this->obj->id > 0  ) {
         echo menulink("department_new.php?id=". $this->obj->id ."&loc_id=-1",$lang['AdrLNew'],sprintf($lang['AdrLNewInfo'],$this->obj->getFullName())) ."<br>";
       }
     }
     echo "</td></tr>";
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->obj = new department($this->dbconn);

     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
       $this->name = $lang['DepartmentModify'] .": ". $this->obj->getFullName();
     } else {
       $this->name = $lang['DepartmentCreate'];
       $this->obj->name     = $lang['PlsChangeName'];
     }
     $this->obj->read_locs_data();
     if ( isset($_GET['loc_id']) ) {
       $this->loc = new location($this->dbconn);
       if ( $_GET['loc_id'] > 0 ) {
         $this->loc->read($_GET['loc_id']);
         $this->loc->lname = $this->obj->loc[$_GET['loc_id']];
       }
       $i = 0;
       while($i < count($this->loc->larray)) {
         $f = $this->loc->larray[$i];
         if ( isset($_GET[$f]) ) {
           $this->loc->$f = $_GET[$f];
         }
         $i++;
       }
     } else {
       $this->loc = "";
     }
     if ( ($this->obj->id < 0) && !$this->user->feature_ok(useaddressbook,PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( ! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }

     if ( isset($_GET['name']) ) {
       $this->obj->name = StripSlashes($_GET['name']);
     }

     # Company
     preset_from_array_or_input($this->obj,'company',"c");

     # menu
     $x = tutos_address::getSelectLink($this->user,$lang['Search']);
     $this->addMenu($x);

     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => "department_del.php?id=".$this->obj->id,
                   text => $lang['Delete'],
                   info => sprintf($lang['DepDelInfo'],$this->obj->getFullName()),
                   category => array("department","del","obj"),
                   confirm => true
                 );
       $this->addMenu($x);
     }
     if ( $this->obj->id > 0 ) {
       $x = array( url => "department_show.php?id=".$this->obj->id,
                   text => $lang['AdrSeeEntry'],
                   info => sprintf($lang['AdrSeeEntryI'],$this->obj->getFullName()),
                   category => array("department","view")
                 );
       $this->addMenu($x);
     }


     add_module_newlinks($this,$this->obj);
   }
 }

 $l = new department_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: department_new.php,v 1.47.2.3 2003/10/01 15:49:26 gokohnert Exp $
    $Author: gokohnert $
-->