#ifndef CATRACK_H
#define CATRACK_H

#include <ClanLib/core.h>

/** Structure for the current track.
    @author Andrew Mustun
*/
struct CATrack {
    //! Track number
    int number;
    //! Track directory name (e.g. "Loops")
    CL_String file;
    //! Track name
    CL_String name;
    //! Version information (e.g. "0.0.1")
    CL_String version;
    //! Author of this track
    CL_String author;
    //! Initial angle of players (0=right, 90=bottom (!))
    int startAngle;
    //! Route points (Usually 1 route per player with x/y)
    int rp[CA_MAXPLAYERS]
    [CA_MAXROUTEPOINTS]
    [2];
    //! Number of route points in this track
    int routePoints;
    //! Pointer to function map
    CL_Canvas*  functionMap;
    //! Pointer to visual map
    CL_Surface* visualMap;
    //! Pointer to bridge surface or NULL if there's no bridge
    CL_Surface* bridge;
    //! Bridge position
    int bridgePos[2];
};

#endif

// EOF
