namespace eval str {
    # No private variables.
}

# str::rpad --
#
#   Method to right pad a string
#
# Args
#
#   str    - String you want to pad.
#   padlen - Length to pad the string to (30)
#   pad    - Padding string i.e. a dash "-".
#
# Returns
#
#   str - The padded string.

proc str::rpad { str padlen {pad " "} } {
    # Find the length of the string
    set len [string length $str]

    # Truncate words that are larger than the padding length,
    # else pad words to their length with the default padding
    # string.
    if {$len > $padlen} {
	return [string range $str 0 [expr $padlen - 1]]
    } else {
	set diff [expr $padlen - $len]
	for {set i 0} {$i < $diff} {incr i} {
	    append str $pad
	    set curlen [string length $str]
	    if {$curlen >= $padlen} {
		return $str
	    }
	}
    }
}

# str::lpad --
#
#   Method to left pad a string.
#
# Args
#
#   str    - String you want to pad.
#   padlen - Length to pad the string to (30)
#   pad    - Padding string i.e. a dash "-".
#
# Returns
#
#   str - The padded string.

proc str::lpad { str padlen {pad " "} } {
    # Find the length of the string
    set len [string length $str]

    # Truncate words that are larger than the padding length,
    # else pad words to their length with the default padding
    # string.
    if {$len >= $padlen} {
	return [string range $str 0 [expr $padlen - 1]]
    } else {
	set diff [expr $padlen - $len]
	set p ""
	for {set i 0} {$i < $diff} {incr i} {
	    append p $pad
	    set curlen [expr [string length $p] + $len]
	    if {$curlen >= $padlen} {
		return "$p$str"
	    }
	}
    }
}
