namespace eval help {
    variable help

    # Define the options database.
    option add *Help.borderwidth 1
    option add *Help.relief flat

    # Define the help data structure
    set help(dialog_id) 0
    set help(dialog) ""
    switch $tkWorld(ostype) {
	windows {
	    set help(font.title) {helvetica 12 bold}
	    set help(font.message) {helvetica 10}
	    set help(font.info) {helvetica 10 italic}
	    set help(font.contact) {helvetica 10}
	}
	default {
	    set help(font.title) {helvetica 14 bold}
	    set help(font.message) {helvetica 12}
	    set help(font.info) {helvetica 12 italic}
	    set help(font.contact) {helvetica 12}
	}
    }
}

# help::msg --
#
#   Method to insert a message into the LW
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc help::msg { subject } {
    global tkWorld
    variable help

    bell

    # Insert the help message into the Log Window.
    $tkWorld(log_window) insert end "Loading $subject help\
	    documentation from the tkWorld website...\n\n"
}

# help::create --
#
#   Method to startup netscape at the tkWorld website
#
# Args
#
#   file    - Currently not supported, but could be used
#             in future releases
#   subject - Currently not used...
#
# Returns
#
#   None.

proc help::create { {file "help_toc.html"} \
	{subject "Table of Contents"} } {
    global tkWorld
    variable help

    # See if netscape is running.
    if [catch {exec ps -x | grep netscape} running] {
	if [regexp "netscape" $running] {
	    set cmd "netscape -raise -remote \
		    'openURL(http://www.tkworld.org/$file)'"
	    if [catch {exec sh -c $cmd} running] {
		stderr::log 6002 "www.tkworld.org/$file"
	    } else {
		help::msg $subject
		return
	    }
	} elseif [catch {exec which netscape} path] {
	    stderr::log 6001 "www.tkworld.org/$file"
	} else {
	    if [catch {exec $path http://www.tkworld.org &} err] {
		stderr::log 6002 "www.tkworld.org/$file"
	    } else {
		help::msg $subject
		return
	    }
	}
    }
}

# help::create_old --
#
#   Deprecated method to create a Help information dialog.
#
# Args
#
#   file    - Name of the help file to point the browser to.
#   subject - The help subject i.e. Command History
#
# Returns
#
#   None.

proc help::create_old { file {subject ""} } {
    global tkWorld
    variable help

    # Increment the dialog id counter.
    incr help::help(dialog_id)

    # Create the dialog.
    set w [toplevel .help$help::help(dialog_id) -class Help]

    # Determine where to place the message popup. Notice the use
    # of .help instead of $w due to the callback in the global space.
    after idle {
	update idletasks

	set xmax [winfo screenwidth .help$help::help(dialog_id)]
	set ymax [winfo screenheight .help$help::help(dialog_id)]
	
	set x0 [expr ($xmax - [winfo reqwidth .help$help::help(dialog_id)])/2]
	set y0 [expr ($ymax - [winfo reqheight .help$help::help(dialog_id)])/2]

	wm geometry .help$help::help(dialog_id) "+$x0+$y0"
    }

    # Create the elements of the placard.
    set img [image create photo \
	    -file [file join $tkWorld(image_dir) tkWorld.gif]]

    label $w.icon \
	    -image $img
    label $w.title \
	    -text "tkWorld-$tkWorld(version) Help\n" \
	    -foreground red \
	    -font $help(font.title)
    label $w.message \
	    -text "Subject: $subject\n" \
	    -font $help(font.message)
    label $w.info \
	    -text "For help on this subject go to:" \
	    -font $help(font.info)
    label $w.contact \
	    -text "$tkWorld(www)/help/$file" \
	    -foreground blue \
	    -font $help(font.contact)
    button $w.ok \
	    -text Ok \
	    -width 5 \
	    -command [list destroy $w]

    # Build the placard with the tkWorld icon.
    grid $w.icon \
	    -row 0 \
	    -column 0 \
	    -rowspan 5 \
	    -padx 5 \
	    -pady 5 \
	    -sticky n
    grid $w.title \
	    -row 0 \
	    -column 1 \
	    -padx 10 \
	    -sticky new
    grid $w.message \
	    -row 1 \
	    -column 1 \
	    -padx 5 \
	    -pady 2 \
	    -sticky ew
    grid $w.info \
	    -row 2 \
	    -column 1 \
	    -padx 5 \
	    -pady 2 \
	    -sticky ew
    grid $w.contact \
	    -row 3 \
	    -column 1 \
	    -padx 5 \
	    -pady 2 \
	    -sticky ew
    grid [seperator::create $w.s1] \
	    -row 4 \
	    -column 0 \
	    -columnspan 2 \
	    -pady 5 \
	    -sticky ew
    grid $w.ok \
	    -row 5 \
	    -column 0 \
	    -columnspan 2 \
	    -padx 5 \
	    -pady 5

    update idletasks

    # Configure the window manager for unix.
    switch $tkWorld(ostype) {
	windows -
	macintosh {
	    # Do nothing
	}
	default {
	    wm title .help$help::help(dialog_id) $subject
	    wm iconbitmap $w \
		    @[file join $tkWorld(image_dir) help.xbm]
	    wm resizable $w 0 0
	}
    }
}
