/****************************************************************************
    Copyright (C) 1987-2004 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Last edit by hansen on Fri May  7 14:08:49 2004
****************************************************************************/
#include <stdio.h>
#include <ctype.h>
#include <sys/time.h>
#include <stdarg.h>
#include <assert.h>
#include "tkgate.h"

int guiActive = 0;

int MESSAGEBARSIZE = 50;

int MB_MESSAGEX = 25;
int MB_MESSAGEY = 40;

int MB_STATUSX = 25;
int MB_STATUSY = 20;

struct MessHist *MBarHist = NULL;	/* Message bar history */
int MBarHistNum = 0;			/* History number */
char MBarText[100] = "";

/*
    The editstate is an optional argument need for modes 2 and 3.
*/
void message(int mode,const char *s,...)
{
  va_list ap;
  char buf[1024];
  extern int quietMode;

  va_start(ap, s);
  vsprintf(buf,s,ap);

  if (guiActive) {
    switch (mode) {
    case 0 :
      Tcl_SetVar(XGate.tcl,"tkg_statusMessage",buf,TCL_LEAVE_ERR_MSG|TCL_GLOBAL_ONLY);
      break;
    case 1 :
    default:
      Tcl_VarEval(XGate.tcl, "errmsg {",buf,"}",0);
      break;
    }
  } else {
    if (!quietMode)
      fprintf(stderr,"tkgate: %s\n",buf);
  }

  va_end(ap);
}

int fontheight(Tk_Font F)
{
  Tk_FontMetrics metrics;

  Tk_GetFontMetrics(F,&metrics);

  return metrics.linespace + 3;
}

/*
    Draw the string ala ZDrawString.  Includes temporary hacked support
    for strings with mixed latin and kanji characters.  Characters with
    the high bit set are assumed to be kanji.  This function is partially
    broken in that it assumes the font for the latin portion is XGate.textF
    when in fact it may be whatever is set in the gc.  For now, since kanji
    is only allowed in comments and frames, this should not be a problem.
*/
void GKDrawString(Display *D,Window W,GC gc,int x,int y,const char *ps,int l)
{
  char buf[STRMAX];
  char *s = buf;

  strncpy(buf,ps,STRMAX);
#if !TKGATE_JSUPPORT
  ZDrawString(D,W,gc,x,y,s,l);
#else
  while (l > 0) {
    int m = 0;
    int i;

    if ((s[0] & 0x80)) {		/* Kanji segment */
      for (m = 0;m < l && (s[m] & 0x80);m++);
      for (i = 0;i < m;i++) s[i] &= 0x7f;
      ZDrawString16(D,W,XGate.kanjiGC,x,y,(XChar2b*)s,m/2);
      if (m != l) x += KANJIFONT_WIDTH*(m/2);
      for (i = 0;i < m;i++) s[i] |= 0x80;
    } else {				/* non-Kanji segment */
      for (m = 0;m < l && !(s[m] & 0x80);m++);
      ZDrawString(D,W,gc,x,y,s,m);
      if (m != l) x += Tk_TextWidth(XGate.textF,s,m);
    }

    l -= m;
    s += m;
  }
#endif
}

/*
   Get the width of a string.  This may be extended in the future to handle
   mixed english/japanese fonts.
*/
int GKTextWidth(Tk_Font F,const char *ps,int l)
{
#if !TKGATE_JSUPPORT
  return Tk_TextWidth(F,ps,l);
#else
  char buf[STRMAX];
  char *s = buf;
  int w = 0;

  strncpy(buf,ps,STRMAX);

  while (l > 0) {
    int m = 0;
    int i;

    if ((s[0] & 0x80)) {		/* Kanji segment */
      for (m = 0;m < l && (s[m] & 0x80);m++);
      for (i = 0;i < m;i++) s[i] &= 0x7f;
      w += KANJIFONT_WIDTH*(m/2);
      for (i = 0;i < m;i++) s[i] |= 0x80;
    } else {				/* non-Kanji segment */
      for (m = 0;m < l && !(s[m] & 0x80);m++);
      w += Tk_TextWidth(F,s,m);
    }

    l -= m;
    s += m;
  }

  return w;
#endif
}

int PosDrawString(Window W,Tk_Font F,GC gc,int x,int y,const char *S,int p)
{
  Tk_FontMetrics metrics;
  int x_w,y_w;

  if (!F) F = XGate.textF;

  Tk_GetFontMetrics(F,&metrics);
  
  if (*S == '_') {
    S++;
    x_w = GKTextWidth(F,S,strlen(S));
    y_w = metrics.linespace + 3;

    if (p & BetweenLeftAndRight) {
      ZDrawLine(XGate.D,W,gc,x - x_w/2,y - 2*y_w/3,
		x + x_w/2,y - 2*y_w/3);
    } else if (p & AtRight) {
      ZDrawLine(XGate.D,W,gc,x - x_w,y - 2*y_w/3,
		x,y - 2*y_w/3);
    } else if (p & AtLeft) {
      ZDrawLine(XGate.D,W,gc,x,y - 2*y_w/3,
		x + x_w,y - 2*y_w/3);
    }
  } else
    x_w = GKTextWidth(F,S,strlen(S));
  
  if (p & BetweenLeftAndRight)
    x -= x_w/2;
  else if (p & AtRight)
    x -= x_w;

  if (p & BetweenTopAndBottom)
    y += (metrics.ascent - metrics.descent)/2;
  else if (p & AtTop)
    y += metrics.ascent;
  else if (p & AtBottom)
    y -= metrics.descent;


  GKDrawString(XGate.D,W,gc,x,y,S,strlen(S));
  
  return x_w + x;
}

int dce_DrawString(GC gc,int x,int y,int p,const char *s)
{
  return PosDrawString(XGate.W,0,gc,ctow_x(x),ctow_y(y),s,p);
}

int RelPosDrawString(Window W,Tk_Font F,GC gc,int x,int y,const char *S,int p)
{
  int ex = PosDrawString(W,F,gc,ctow_x(x),ctow_y(y),S,p);
  return wtoc_x(ex);
}
