/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ContestSelectDlg.H"
#include "commonElements.H"
#include <wx/statline.h>

enum {
  LB = 1,
  BTN_SEL
};

BEGIN_EVENT_TABLE(ContestSelectDlg,wxDialog)
  EVT_BUTTON(BTN_ADD,ContestSelectDlg::onButtonAdd)
  EVT_BUTTON(BTN_DEL,ContestSelectDlg::onButtonDel)
  EVT_BUTTON(BTN_EDIT,ContestSelectDlg::onButtonEdit)
  EVT_BUTTON(BTN_SEL,ContestSelectDlg::onButtonSelect)
  EVT_LISTBOX(LB,ContestSelectDlg::onListBoxSelect)
  EVT_LISTBOX_DCLICK(LB,ContestSelectDlg::onButtonEdit)
END_EVENT_TABLE()

ContestSelectDlg::ContestSelectDlg (wxWindow* parent)
  : wxDialog(parent,-1, wxString(_("Contests")),
	     wxDefaultPosition, wxDefaultSize,
	     wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER)
{
  wxBoxSizer* dialogSizer = new wxBoxSizer(wxVERTICAL);
  dialogSizer->Add(selectSizer(),1,wxEXPAND|wxALL,10);
  dialogSizer->Add(new wxStaticLine(this,-1),0,wxEXPAND|wxLEFT|wxRIGHT,10);
  dialogSizer->Add(bottomButtonSizer(),0,wxALIGN_CENTER|wxALL,10);

  SetSizer(dialogSizer);
  dialogSizer->SetSizeHints(this);
  Centre();
}

ContestSelectDlg::~ContestSelectDlg () {
  delete l;
}

int ContestSelectDlg::ShowModal () {
  if (this->lb->GetCount() == 0) {
    wxDialog::Show();
    wxCommandEvent e(wxEVT_COMMAND_BUTTON_CLICKED,BTN_ADD);
    ProcessEvent(e);
    wxDialog::Hide();
  }
  if (this->lb->GetCount() == 0) {
    return wxID_CANCEL;
  } else {
    return wxDialog::ShowModal();
  }
}

wxSizer* ContestSelectDlg::bottomButtonSizer () {
  wxBoxSizer* sizer = new wxBoxSizer(wxHORIZONTAL);
  sizer->Add(new wxButton(this,BTN_SEL,_("Select")),
	     0,wxEXPAND|wxALIGN_CENTER|wxRIGHT,10);
  sizer->Add(new wxButton(this,wxID_CANCEL,_("Cancel")),
	     0,wxEXPAND|wxALIGN_CENTER);
  return sizer;
}

wxSizer* ContestSelectDlg::selectSizer () {
  wxBoxSizer* sizer = new wxBoxSizer(wxHORIZONTAL);
  sizer->Add(selectSizerListBox(),1,wxEXPAND);
  sizer->Add(new wxStaticLine(this,-1,wxDefaultPosition,
			      wxDefaultSize,wxLI_VERTICAL),
	     0,wxEXPAND|wxLEFT|wxRIGHT,5);
  sizer->Add(common::listChangeButtons(this),0,wxEXPAND);
  wxWindow::FindWindow(BTN_DEL)->Disable();
  wxWindow::FindWindow(BTN_EDIT)->Disable();
  return sizer;
}

#include "ConfigFile.H"

wxListBox* ContestSelectDlg::selectSizerListBox () {
  //these values are only the minimal size
  int lbWidth = 250;
  int lbHeight = 200;
  this->l = TtConfigFile::getPtr()->getContests();
  this->lb = new wxListBox(this, LB, wxDefaultPosition, wxSize(lbWidth,lbHeight));
  for (unsigned int i=0;i<l->size();++i) {
    this->lb->Append((*this->l)[i].title);
  }
  this->lb->SetSizeHints(lbWidth,lbHeight);
  return this->lb;
}

#include "ContestPropDlg.H"

void ContestSelectDlg::onButtonAdd (wxCommandEvent& e) {
  ContestPropDlg* dialog = new ContestPropDlg(this);
  if (dialog->ShowModal() == wxID_OK) {
    ContestDesc temp = dialog->getContestDesc();
    this->lb->Append(temp.title); //listbox
    //now store at (also sets the id field)
    TtConfigFile::getPtr()->setContest(temp); //data in config file
    this->l->push_back(temp); //data in memory
  }
}

void ContestSelectDlg::onButtonDel (wxCommandEvent& e) {
  int i = this->lb->GetSelection();
  this->lb->Delete(i);
  TtConfigFile::getPtr()->deleteContest((*this->l)[i].id);
  this->l->erase(this->l->begin()+i);
  if (this->l->size()==0) {
    wxWindow::FindWindow(BTN_DEL)->Disable();
    wxWindow::FindWindow(BTN_EDIT)->Disable();  
  }
}

void ContestSelectDlg::onButtonEdit (wxCommandEvent& e) {
  int i = this->lb->GetSelection();
  ContestPropDlg* dialog = new ContestPropDlg(this,(*this->l)[i]);
  if (dialog->ShowModal() == wxID_OK) {
    ContestDesc temp = dialog->getContestDesc();
    TtConfigFile::getPtr()->setContest(temp);
    this->lb->SetString(i,temp.title);
    this->l->erase(this->l->begin()+i);
    if (i==0) {
      this->l->push_back(temp);
    } else {
      this->l->insert(this->l->begin()+i,temp);
    }
  }
}

void ContestSelectDlg::onButtonSelect (wxCommandEvent& e) {
  if (this->l->size() > 0) {
    TtConfigFile::getPtr()->setSelectedContestId((*this->l)[this->lb->GetSelection()].id);
    EndModal(wxID_CANCEL);
  } else {
    EndModal(wxID_OK);
  }
}

void ContestSelectDlg::onListBoxSelect (wxCommandEvent& e) {
  wxWindow::FindWindow(BTN_DEL)->Enable();
  wxWindow::FindWindow(BTN_EDIT)->Enable();  
}
