/*
;* Bitmap functions
;* Copyright (C) 2003 PpHd 
;* Copyright (C) 2002-2005 Kevin Kofler
;*
;* This program is free software ; you can redistribute it and/or modify it under the
;* terms of the GNU General Public License as published by the Free Software Foundation;
;* either version 2 of the License, or (at your option) any later version. 
;* 
;* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
;* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
;* See the GNU General Public License for more details. 
;* 
;* You should have received a copy of the GNU General Public License along with this program;
;* if not, write to the 
;* Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */
 
// Direct compilation ? or include from the test program ?
#ifndef	USE_KERNEL

#define _GENERIC_ARCHIVE
#define NULL 0

typedef union { 
 struct { unsigned char x0, y0, x1, y1; } xy; 
 unsigned long l; 
} SCR_RECT; 

enum Attrs{A_REVERSE,A_NORMAL,A_XOR,A_SHADED,A_REPLACE,A_OR,A_AND,A_THICK1,A_SHADE_V,A_SHADE_H,A_SHADE_NS,A_SHADE_PS};

extern		SCR_RECT ScrRect;
extern	char	*CURRENT_SCREEN;
extern	short	CURRENT_INCY;

#define	GET_XMAX (ScrRect.xy.x1)
#define	GET_YMAX (ScrRect.xy.y1)

void	BitmapInit(const SCR_RECT *rect, short *BitMap);
void	ScrRectFill (const SCR_RECT *rect, const SCR_RECT *clip, short Attr);
#define	ClrScr	ScreenClear

#else
char *CURRENT_SCREEN;		// Global positions
#define	GET_XMAX (ScrRect->xy.x1)
#define	GET_YMAX (ScrRect->xy.y1)
#endif

void	BitmapGet(const SCR_RECT *rect, short *BitMap)
{
  short x, y, height, w, bytewidth;
  unsigned char* dest;
  unsigned short FinalMask;
	
  BitmapInit(rect, BitMap);
  x = rect->xy.x0;
  y = rect->xy.y0;
  height = rect->xy.y1 - rect->xy.y0 + 1;
  w = rect->xy.x1 - rect->xy.x0 + 1;
  FinalMask = (0xFF >> (8-(w&7))) << (8-(w&7));
  bytewidth = /*((w-1)>>3)+1*/ (w+7) >> 3;
  dest = (unsigned char *) ((short *) BitMap+2);

  short i,j;
  unsigned short incy=CURRENT_INCY>>1;
  short oddy=CURRENT_INCY&1;
  unsigned short xshift0=24-(x&15);
  unsigned short xshift1=24-((x+8)&15);
  for (i=0;i<height;i++) {
    short yc=y+i;
    for (j=0;j<bytewidth;j++) {
      short xc=x+(j<<3);
      unsigned short isodd=yc&oddy;
      unsigned short isodd2=(j+isodd)&1;
      unsigned short xshift=isodd2?xshift1:xshift0;
      unsigned long d=*(unsigned long *)((short *)CURRENT_SCREEN+(yc*incy+(xc>>4)+(j&isodd)));
      d>>=xshift;
      *(dest++)=(unsigned char)d;
    }
    if (j) dest[-1]&=FinalMask;
  }
}

void SpriteX8_or(short x,short y,short height,unsigned char* sprite,short bytewidth,short* dest,SCR_RECT *clip) {
  short i,j;
  unsigned short incy=CURRENT_INCY>>1;
  short oddy=CURRENT_INCY&1;
  unsigned short xshift0=24-(x&15);
  unsigned short xshift1=24-((x+8)&15);
  for (i=0;i<height;i++) {
    short yc=y+i;
    if (!clip || ((yc>=clip->xy.y0)&&(yc<=clip->xy.y1))) {
      for (j=0;j<bytewidth;j++) {
        short xc=x+(j<<3);
        if (!clip || ((xc>clip->xy.x0-8) && (xc<=clip->xy.x1))) {
          unsigned short isodd=yc&oddy;
          unsigned short isodd2=(j+isodd)&1;
          unsigned short xshift=isodd2?xshift1:xshift0;
          unsigned long d=*(sprite++);
          d<<=xshift;
          unsigned long mask=0xFFFFFFFFul;
          if (clip) {
            if (isodd2) {
              if (xc<clip->xy.x0) mask&=0xFFul;
              if (xc>clip->xy.x1-7) mask&=0xFFFFFF00ul;
            } else {
              if (xc<clip->xy.x0) mask&=0xFFFFul;
              if (xc>clip->xy.x1-7) mask&=0xFFFF0000ul;
            }
          }
          d&=mask;
          *(unsigned long *)(dest+(yc*incy+(xc>>4)+(j&isodd)))|=d;
        } else sprite++;
      }
    } else sprite+=bytewidth;
  }
}

void SpriteX8_and(short x,short y,short height,unsigned char* sprite,short bytewidth,short* dest,SCR_RECT *clip) {
  short i,j;
  unsigned short incy=CURRENT_INCY>>1;
  short oddy=CURRENT_INCY&1;
  unsigned short xshift0=24-(x&15);
  unsigned short xshift1=24-((x+8)&15);
  for (i=0;i<height;i++) {
    short yc=y+i;
    if (!clip || ((yc>=clip->xy.y0)&&(yc<=clip->xy.y1))) {
      for (j=0;j<bytewidth;j++) {
        short xc=x+(j<<3);
        if (!clip || ((xc>clip->xy.x0-8) && (xc<=clip->xy.x1))) {
          unsigned short isodd=yc&oddy;
          unsigned short isodd2=(j+isodd)&1;
          unsigned short xshift=isodd2?xshift1:xshift0;
          unsigned long d=*(sprite++);
          d<<=xshift;
          unsigned long mask=0;
          if (clip) {
            if (isodd2) {
              if (xc<clip->xy.x0) mask|=0xFFFFFF00ul;
              if (xc>clip->xy.x1-7) mask|=0xFFul;
            } else {
              if (xc<clip->xy.x0) mask|=0xFFFF0000ul;
              if (xc>clip->xy.x1-7) mask|=0xFFFFul;
            }
          }
          d|=mask;
          *(unsigned long *)(dest+(yc*incy+(xc>>4)+(j&isodd)))&=d;
        } else sprite++;
      }
    } else sprite+=bytewidth;
  }
}

void SpriteX8_xor(short x,short y,short height,unsigned char* sprite,short bytewidth,short* dest,SCR_RECT *clip) {
  short i,j;
  unsigned short incy=CURRENT_INCY>>1;
  short oddy=CURRENT_INCY&1;
  unsigned short xshift0=24-(x&15);
  unsigned short xshift1=24-((x+8)&15);
  for (i=0;i<height;i++) {
    short yc=y+i;
    if (!clip || ((yc>=clip->xy.y0)&&(yc<=clip->xy.y1))) {
      for (j=0;j<bytewidth;j++) {
        short xc=x+(j<<3);
        if (!clip || ((xc>clip->xy.x0-8) && (xc<=clip->xy.x1))) {
          unsigned short isodd=yc&oddy;
          unsigned short isodd2=(j+isodd)&1;
          unsigned short xshift=isodd2?xshift1:xshift0;
          unsigned long d=*(sprite++);
          d<<=xshift;
          unsigned long mask=0xFFFFFFFFul;
          if (clip) {
            if (isodd2) {
              if (xc<clip->xy.x0) mask&=0xFFul;
              if (xc>clip->xy.x1-7) mask&=0xFFFFFF00ul;
            } else {
              if (xc<clip->xy.x0) mask&=0xFFFFul;
              if (xc>clip->xy.x1-7) mask&=0xFFFF0000ul;
            }
          }
          d&=mask;
          *(unsigned long *)(dest+(yc*incy+(xc>>4)+(j&isodd)))^=d;
        } else sprite++;
      }
    } else sprite+=bytewidth;
  }
}


void BitmapPut (short x, short y, const short *BitMap, const SCR_RECT *clip, short Attr)
{
	SCR_RECT	r;
	short	h, w;
	h = *(BitMap++);
	w = *(BitMap++);
	
	r.xy.x0 = x;
	r.xy.y0 = y;
	r.xy.y1 = y + h-1;
	r.xy.x1 = x + w-1;
	
	switch (Attr)
	{
	case	A_REVERSE:
		ScrRectFill(&r, clip, A_NORMAL);	
	case	A_XOR:
		SpriteX8_xor(x, y, h, (unsigned char *) BitMap, ((w-1)>>3)+1, CURRENT_SCREEN, clip);
		break;
	case	A_REPLACE:
		ScrRectFill(&r, clip, A_REVERSE);
	case	A_NORMAL:
	case	A_OR:
		SpriteX8_or(x, y, h, (unsigned char *) BitMap, ((w-1)>>3)+1, CURRENT_SCREEN, clip);
		break;	
	case	A_AND:
		SpriteX8_and(x, y, h, (unsigned char *) BitMap, ((w-1)>>3)+1, CURRENT_SCREEN, clip);
	default:
		break;
	}
}
