#! /bin/sh
## tlsgencert.sh -- Generate SSL certificates for HTTPS
## (C) 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
##
## This file is part of Thy.
##
## Thy is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation; version 2 dated June, 1991.
##
## Thy is distributed in the hope that it will be useful, but WITHOUT
## ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
## or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
## License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

set -e

get_hostname ()
{
	HOST_S=$(hostname -s)
	if [ "$(uname -s)" != "Linux" ]; then
		HOST_L=$(hostname)
	else
		HOST_L=$(hostname -f 2>/dev/null)
	fi
	if [ -z "${HOST_L}" ] || [ "${HOST_L}" = "${HOST_S}" ]; then
		HOST_L=$(hostname)
	fi
	echo ${HOST_L}
}

extract_info ()
{
	sed -e "s;.*/$1=\([^/]\{1,\}\).*;\\${2:-1};"
}

create_ssl_cnf ()
{
	if [ -e Thy-CA/cacert.pem ]; then
		STUFF=$(openssl verify Thy-CA/cacert.pem | head -n 1 | sed -e "s,^[^:]*: ,,g")
		C=$(echo ${STUFF} | extract_info "C")
		L=$(echo ${STUFF} | extract_info "L")
		OU=$(echo ${STUFF} | extract_info "OU")
		CN=$(echo ${STUFF} | extract_info "CN")
		EMAIL=$(echo ${STUFF} | extract_info "email\(Address\)*" 2)
		ST=$(echo ${STUFF} | extract_info "ST")
		O=${CN}
	else
		CN=$(get_hostname)
		EMAIL="webmaster@${CN}"
		O="${CN}-CA"
		OU="Thy HTTPS server"
	fi
	sed -e "s,@@C@@,${C},g" \
	    -e "s,@@ST@@,${ST},g" \
	    -e "s,@@L@@,${L},g" \
	    -e "s,@@O@@,${O},g" \
	    -e "s,@@OU@@,${OU},g" \
	    -e "s,@@CN@@,${CN},g" \
	    -e "s,@@emailAddress@@,${EMAIL},g" \
	    <ssl.cnf.in >Thy-CA/ssl.cnf
}

if [ ! -e Thy-CA ]; then
	for d in Thy-CA Thy-CA/certs Thy-CA/crl Thy-CA/newcerts Thy-CA/private; do
		mkdir $d
	done

	echo 01 >Thy-CA/serial
fi

rm -f Thy-CA/index.txt
touch Thy-CA/index.txt

create_ssl_cnf

openssl req -new -x509 -keyout Thy-CA/private/cakey.pem \
	-out Thy-CA/cacert.pem -config Thy-CA/ssl.cnf

create_ssl_cnf

openssl req -new -keyout Thy-CA/newreq.pem -out Thy-CA/newreq.pem \
	-nodes  -config Thy-CA/ssl.cnf
openssl ca -policy policy_anything -config Thy-CA/ssl.cnf \
	-out Thy-CA/newcert.pem -infiles Thy-CA/newreq.pem

cp Thy-CA/newcert.pem cert.pem
cp Thy-CA/newreq.pem key.pem
cp Thy-CA/cacert.pem ca.pem
