<?php
/* errordoc.php -- Sample PHP script, to be used as an errordocument.
 * Copyright (C) 2002, 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of Thy.
 *
 * Thy is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * Thy is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

$STATUS[301] = "Moved Permanently";
$STATUS[302] = "Found";
$STATUS[400] = "Bad Request";
$STATUS[401] = "Unauthorized";
$STATUS[403] = "Forbidden";
$STATUS[404] = "Not Found";
$STATUS[405] = "Method Not Allowed";
$STATUS[411] = "Length Required";
$STATUS[412] = "Precondition Failed";
$STATUS[413] = "Request Entity Too Large";
$STATUS[416] = "Requested Range Not Satisfiable";
$STATUS[500] = "Internal Server Error";
$STATUS[501] = "Not Implemented";
$STATUS[503] = "Service Unavailable";
$STATUS[505] = "HTTP Version Not Supported";

$message = "An internal server error occurred while serving your request.\n" .
"Please contact the site administrator and try again later.";

switch ($_SERVER["REDIRECT_STATUS"])
{
 case 301:
   $message = "The document you requested has moved elsewhere.";
   break;

 case 302:
   $message = "The document you requested has been found elsewhere.\n" .
     "Your browser should take you to the new location.";
   header ("Location: " . $_SERVER["REQUEST_URI"] . "/");
   break;

 case 400:
   $message = "There was a problem parsing your request: \n<pre>" .
     $_SERVER["REDIRECT_REQUEST"] . "</pre>\n" .
     "Please fix your browser and try again.";
   break;

 case 401:
   $message = "You are not authorized to access this document.";
   if ($_SERVER["HTTP_REFERER"])
     $message = $message . "\nPlease check the ".
       "<a href=\"" . $_SERVER["HTTP_REFERER"] . "\">referring page</a>.";
   break;

 case 403:
   $message = "You don't have permission to access this document.";
   break;

 case 404:
   $message = "The document you requested (" . $_SERVER["REQUEST_URI"] . ") cannot " .
     "be found on this server.<br>\n" .
     "Please contact the site administrator";
   if ($_SERVER["HTTP_REFERER"])
     $message = $message . " or check the\n" .
       "<a href=\"" . $_SERVER["HTTP_REFERER"] . "\">referring page</a>";
   $message = $message . ".";
   break;

 case 405:
   $message = "The <i>" . $_SERVER["REQUEST_METHOD"] . "</i> method is inappropriate ".
     "for this document.";
   break;

 case 411:
   $message = "The request was refused because it did not contain the " .
     "required Content-Length header. Please try again with the " .
     "appropriate header added.";
   break;
   
 case 412:
   $message = "The precondition given in one or more of the request-header\n" .
     "fields evaluated to false when it was tested on the server.";
   break;

 case 413:
   $message = "The server is refusing to process the request because it is " .
     "larger than it is willing to process.";
   break;

 case 416:
   $stuff = explode ("=", $_SERVER["HTTP_RANGE"]);
   $message = "The requested range ($stuff[1]) cannot be" .
     "satisfied.";
   break;

 case 501:
   $message = "The server does not support the functionality required ".
     "to fulfil your request.";
   break;

 case 503:
   $message = "The server is currently unable to handle the request due ".
     "to a temporary overloading.";
   break;
   
 case 505:
   $stuff = explode (" ", $_SERVER["REDIRECT_REQUEST"]);
   $stuff = explode ("/", $stuff[2]);
   $message = "HTTP version $stuff[1] is not supported by this ".
     "server.\nPlease try again with HTTP/1.0 or HTTP/1.1. ";
   break;

 default:
   $_SERVER["REDIRECT_STATUS"] = 500;
   break;
}
header ("Server: " . $_SERVER["SERVER_SOFTWARE"] . " PHP/" . PHP_VERSION .
	" (" . PHP_OS .")");
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
 <title><?= $_SERVER["REDIRECT_STATUS"] ?> <?php
 ?><?= $STATUS[$_SERVER["REDIRECT_STATUS"]]; ?></title>
 <meta name="generator" content="<?= $_SERVER["SERVER_SOFTWARE"]; ?> <?php
  ?>PHP/<?= PHP_VERSION; ?> (<?= PHP_OS ?>)">
 <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
</head>

<body bgcolor="#ffffff" text="#000000">
<h1><?= $_SERVER["REDIRECT_STATUS"]; ?>
 <?= $STATUS[$_SERVER["REDIRECT_STATUS"]]; ?></h1>

<?= $message; ?>

</body>
</html>
