require 'tempura/div'

class Controller < Tempura::Div

  attr_reader :lang

  def self.set_model_factory( factory )
    @@model_factory = factory
  end

  def initialize(session)
    super(session)
    @model = @@model_factory.new
  end

  def do_lang(context, params)
    @lang = params['lang'].first
    select_template( @lang )
  end

  def do_add(context, params)
    name = params['name'].first
    price = params['price'].first.to_i
    @model.add_item(name, price)
  end

  def do_del(context, params)
    name = params['name'].first
    @model.del_item(name)
  end

  def do_reset(context, params)
    @model.reset
  end

end
