# -*- Mode: ruby; indent-tabs-mode: nil -*-
#
#  $Id: charconv.rb,v 1.4 2003/09/22 15:21:15 hisa Exp $
#
#  Copyright (c) 2003 FUJIMOTO Hisakuni <hisa@fobj.com>
#
#  This program is free software.
#  You can distribute/modify this program under the terms of
#  the GNU Lesser General Public License version 2.
#
module Tempura

  if not defined? CharConvDefault then
    module CharConvDefault
      module_function

      def to_u8( str )
        return str
      end

      def from_u8( str )
        return str
      end

    end #   module CharConvDefault
  end   # if not defined? CharConvDefault

  module CharConvEUC
    module_function

    def to_u8( str )
      require 'uconv'
      return Uconv::euctou8( str )
    end

    def from_u8( str )
      require 'uconv'
      return Uconv::u8toeuc( str )
    end

  end # module CharConvEUC

  module CharConvSJIS
    module_function

    def to_u8( str )
      require 'uconv'
      return Uconv::sjistou8( str )
    end

    def from_u8( str )
      require 'uconv'
      return Uconv::u8tosjis( str )
    end

  end # module CharConvSJIS

end
