/*
 * tcpreen.h - header for tcpreen.c
 * $Id: tcpreen.h,v 1.6 2003/01/26 09:09:08 rdenisc Exp $
 */

/***********************************************************************
 *  Copyright (C) 2002-2003 Rmi Denis-Courmont.                       *
 *  This program is free software; you can redistribute and/or modify  *
 *  it under the terms of the GNU General Public License as published  *
 *  by the Free Software Foundation; version 2 of the license.         *
 *                                                                     *
 *  This program is distributed in the hope that it will be useful,    *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               *
 *  See the GNU General Public License for more details.               *
 *                                                                     *
 *  You should have received a copy of the GNU General Pulic License   *
 *  along with this program; if not, you can get it from:              *
 *  http://www.gnu.org/copyleft/gpl.html                               *
 ***********************************************************************/

#ifndef __TCPREEN_TCPREEN_H

# define _TCPREEN_TCPREEN_H
# ifdef HAVE_SYS_TYPES_H
#  include <sys/types.h> /* uid_t */
# endif

# include "log.h"
# include "socketinfo.h"

enum
{
	tcpreen_normal=0x00,
	tcpreen_listen_both=0x01,
	tcpreen_connect_both=0x02,
	tcpreen_reversed=0x03, /* warning */
	tcpreen_numeric=0x04,
	tcpreen_daemon=0x08,
	tcpreen_syslog=0x10,
	tcpreen_verbose=0x20,
	tcpreen_speak=0x30
};

struct bridgeconf
{
	struct sockhostinfo server, bridge;
	DataLogListMaker *logmaker;
	int mode, maxclients;
	long bytelimit, totalclients;
	uid_t priv, unpriv;
};

int bridge_main (const struct bridgeconf *conf);
#endif

