/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.compile;

import org.jatha.Jatha;
import org.jatha.compile.CompilerException;
import org.jatha.compile.LispCompiler;
import org.jatha.compile.LispPrimitive;
import org.jatha.dynatype.LispString;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.StandardLispConstant;
import org.jatha.machine.SECDMachine;

public class DefconstantPrimitive
extends LispPrimitive {
    public DefconstantPrimitive(Jatha lisp) {
        super(lisp, "DEFCONSTANT", 2L, 3L);
    }

    public void Execute(SECDMachine machine) {
        LispValue val = machine.S.pop();
        LispValue sym = machine.S.pop();
        if (sym.boundp() == this.f_lisp.T) {
            System.err.println("Warning: Constant " + sym + " being redefined from " + sym.symbol_value() + " to " + val);
        }
        sym.setf_symbol_value(val);
        StandardLispConstant newSymbol = new StandardLispConstant(this.f_lisp, sym);
        this.f_lisp.SYMTAB.replace((LispString)sym.symbol_name(), newSymbol);
        newSymbol.set_special(true);
        machine.S.push(sym);
        machine.C.pop();
    }

    public LispValue CompileArgs(LispCompiler compiler, SECDMachine machine, LispValue args, LispValue valueList, LispValue code) throws CompilerException {
        return this.f_lisp.makeCons(machine.LDC, this.f_lisp.makeCons(args.first(), compiler.compile(args.second(), valueList, code)));
    }
}

