/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.UserEvent;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.FunctionDataWindow;
import edu.uoregon.tau.paraprof.HistogramWindow;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.PPUserEventProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.StatWindow;
import edu.uoregon.tau.paraprof.UserEventWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class StatWindowPanel
extends JPanel
implements ActionListener,
MouseListener,
Printable,
ParaProfImageInterface {
    private int xPanelSize = 800;
    private int yPanelSize = 600;
    private int newXPanelSize = 0;
    private int newYPanelSize = 0;
    private int startLocation = 0;
    private int maxFontAscent = 0;
    private int maxFontDescent = 0;
    private int spacing = 0;
    private ParaProfTrial trial = null;
    private StatWindow window = null;
    private boolean userEventWindow;
    private Vector list = null;
    private Font monoFont = null;
    private FontMetrics fmMonoFont = null;
    private JPopupMenu popup = new JPopupMenu();
    private Object clickedOnObject = null;
    private int lastHeaderEndPosition = 0;

    public StatWindowPanel(ParaProfTrial paraProfTrial, int n, int n2, int n3, StatWindow statWindow, boolean bl) {
        JMenuItem jMenuItem;
        this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
        this.setBackground(Color.white);
        this.trial = paraProfTrial;
        this.window = statWindow;
        this.userEventWindow = bl;
        this.addMouseListener(this);
        if (bl) {
            jMenuItem = new JMenuItem("Show User Event Details");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Change User Event Color");
            jMenuItem2.addActionListener(this);
            this.popup.add(jMenuItem2);
        } else {
            jMenuItem = new JMenuItem("Show Function Details");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            JMenuItem jMenuItem3 = new JMenuItem("Show Function Histogram");
            jMenuItem3.addActionListener(this);
            this.popup.add(jMenuItem3);
            JMenuItem jMenuItem4 = new JMenuItem("Change Function Color");
            jMenuItem4.addActionListener(this);
            this.popup.add(jMenuItem4);
        }
        jMenuItem = new JMenuItem("Reset to Generic Color");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.renderIt((Graphics2D)graphics, true, false, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            this.window.closeThisWindow();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.xPanelSize, this.yPanelSize);
            this.renderIt((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            new ParaProfErrorDialog(exception);
            return 1;
        }
    }

    public static String getUserEventStatStringHeading() {
        int n = 18;
        return UtilFncs.pad((String)"NumSamples", (int)n) + UtilFncs.pad((String)"Max", (int)n) + UtilFncs.pad((String)"Min", (int)n) + UtilFncs.pad((String)"Mean", (int)n) + UtilFncs.pad((String)"Std. Dev", (int)n);
    }

    public void renderIt(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        int n;
        this.list = this.window.getData();
        if (this.list.size() == 0) {
            return;
        }
        PPFunctionProfile pPFunctionProfile = null;
        PPUserEventProfile pPUserEventProfile = null;
        int n2 = 0;
        String string = null;
        String string2 = "";
        int n3 = 0;
        int n4 = this.trial.getPreferences().getBarHeight();
        this.spacing = this.trial.getPreferences().getBarSpacing();
        this.monoFont = new Font("Monospaced", this.trial.getPreferences().getFontStyle(), n4);
        this.fmMonoFont = graphics2D.getFontMetrics(this.monoFont);
        this.maxFontAscent = this.fmMonoFont.getMaxAscent();
        this.maxFontDescent = this.fmMonoFont.getMaxDescent();
        graphics2D.setFont(this.monoFont);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        if (this.spacing <= this.maxFontAscent + this.maxFontDescent) {
            ++this.spacing;
        }
        if (bl3) {
            Insets insets = this.getInsets();
            n2 += this.spacing;
            String string3 = this.window.getHeaderString();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "'\n'");
            while (stringTokenizer.hasMoreTokens()) {
                AttributedString attributedString = new AttributedString(stringTokenizer.nextToken());
                attributedString.addAttribute(TextAttribute.FONT, this.monoFont);
                AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                float f = this.getSize().width - insets.left - insets.right;
                float f2 = insets.left;
                float f3 = insets.right;
                while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                    TextLayout textLayout = lineBreakMeasurer.nextLayout(f);
                    textLayout.draw(graphics2D, f2, n2 += this.spacing);
                    f2 = insets.left;
                }
            }
            this.lastHeaderEndPosition = n2;
        }
        string = this.userEventWindow ? StatWindowPanel.getUserEventStatStringHeading() : (this.trial.isTimeMetric() ? PPFunctionProfile.getStatStringHeading("Time") : PPFunctionProfile.getStatStringHeading("Counts"));
        int n5 = this.fmMonoFont.stringWidth(string) + 20;
        string = string + "Name";
        int n6 = string.length();
        for (n = 0; n < n6; ++n) {
            string2 = string2 + "-";
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string2, 20, n2 += this.spacing);
        n2 = n2 + this.spacing + 10;
        graphics2D.drawString(string, 20, n2);
        n2 = n2 + this.spacing + 10;
        graphics2D.drawString(string2, 20, n2);
        if (bl) {
            this.startLocation = n2;
        }
        this.newYPanelSize = n2 + (this.list.size() + 1) * this.spacing;
        n = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        if (!bl2) {
            if (bl) {
                rectangle = graphics2D.getClipBounds();
                n = (int)rectangle.getY();
                n7 = (int)((double)n + rectangle.getHeight());
            } else {
                rectangle2 = this.window.getViewRect();
                n = (int)rectangle2.getY();
                n7 = (int)((double)n + rectangle2.getHeight());
            }
            n8 = (n - n2) / this.spacing - 1;
            n9 = (n7 - n2) / this.spacing + 1;
            if (n8 < 0) {
                n8 = 0;
            }
            if (n9 < 0) {
                n9 = 0;
            }
            if (n8 > this.list.size() - 1) {
                n8 = this.list.size() - 1;
            }
            if (n9 > this.list.size() - 1) {
                n9 = this.list.size() - 1;
            }
            if (bl) {
                n2 += n8 * this.spacing;
            }
        } else {
            n8 = 0;
            n9 = this.list.size() - 1;
        }
        for (int i = n8; i <= n9; ++i) {
            UserEvent userEvent;
            if (this.userEventWindow) {
                pPUserEventProfile = (PPUserEventProfile)this.list.elementAt(i);
                string = pPUserEventProfile.getUserEventStatString(ParaProf.defaultNumberPrecision);
            } else {
                pPFunctionProfile = (PPFunctionProfile)this.list.elementAt(i);
                string = pPFunctionProfile.getStatString(this.window.units());
            }
            n2 += this.spacing;
            graphics2D.setColor(Color.black);
            int n10 = -1;
            if (this.userEventWindow) {
                userEvent = this.trial.getColorChooser().getHighlightedUserEvent();
                if (userEvent != null) {
                    n10 = userEvent.getID();
                }
            } else {
                userEvent = this.trial.getColorChooser().getHighlightedFunction();
                if (userEvent != null) {
                    n10 = userEvent.getID();
                }
            }
            if (this.userEventWindow && pPUserEventProfile.getUserEvent().getID() == n10 || !this.userEventWindow && pPFunctionProfile.getFunction().getID() == n10) {
                graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                new TextLayout(string, this.monoFont, fontRenderContext).draw(graphics2D, 20.0f, n2);
                if (this.userEventWindow) {
                    graphics2D.setColor(pPUserEventProfile.getColor());
                    new TextLayout(pPUserEventProfile.getUserEventName(), this.monoFont, fontRenderContext).draw(graphics2D, n5, n2);
                } else {
                    graphics2D.setColor(pPFunctionProfile.getColor());
                    new TextLayout(pPFunctionProfile.getFunctionName(), this.monoFont, fontRenderContext).draw(graphics2D, n5, n2);
                }
            } else if (!this.userEventWindow && pPFunctionProfile.isGroupMember(this.trial.getColorChooser().getHighlightedGroup())) {
                graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                new TextLayout(string, this.monoFont, fontRenderContext).draw(graphics2D, 20.0f, n2);
                graphics2D.setColor(pPFunctionProfile.getColor());
                new TextLayout(pPFunctionProfile.getFunctionName(), this.monoFont, fontRenderContext).draw(graphics2D, n5, n2);
            } else {
                new TextLayout(string, this.monoFont, fontRenderContext).draw(graphics2D, 20.0f, n2);
                if (this.userEventWindow) {
                    graphics2D.setColor(pPUserEventProfile.getColor());
                    new TextLayout(pPUserEventProfile.getUserEventName(), this.monoFont, fontRenderContext).draw(graphics2D, n5, n2);
                } else {
                    graphics2D.setColor(pPFunctionProfile.getColor());
                    new TextLayout(pPFunctionProfile.getFunctionName(), this.monoFont, fontRenderContext).draw(graphics2D, n5, n2);
                }
            }
            if (this.userEventWindow) {
                if (n3 >= 20 + n5 + this.fmMonoFont.stringWidth(pPUserEventProfile.getUserEventName())) continue;
                n3 = 20 + n5 + this.fmMonoFont.stringWidth(pPUserEventProfile.getUserEventName());
                continue;
            }
            if (n3 >= 20 + n5 + this.fmMonoFont.stringWidth(pPFunctionProfile.getFunctionName())) continue;
            n3 = 20 + n5 + this.fmMonoFont.stringWidth(pPFunctionProfile.getFunctionName());
        }
        if (this.newYPanelSize != this.yPanelSize || n3 >= this.xPanelSize) {
            this.yPanelSize = this.newYPanelSize + 1;
            this.xPanelSize = n3 + 1;
            this.revalidate();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            PPUserEventProfile pPUserEventProfile = null;
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Function Details")) {
                    if (this.clickedOnObject instanceof PPFunctionProfile) {
                        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)this.clickedOnObject;
                        FunctionDataWindow functionDataWindow = new FunctionDataWindow(this.trial, pPFunctionProfile.getFunction(), this.trial.getStaticMainWindow().getDataSorter());
                        this.trial.getSystemEvents().addObserver(functionDataWindow);
                        functionDataWindow.show();
                    }
                } else if (string.equals("Show Function Histogram")) {
                    if (this.clickedOnObject instanceof PPFunctionProfile) {
                        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)this.clickedOnObject;
                        HistogramWindow histogramWindow = new HistogramWindow(this.trial, this.window.getDataSorter(), pPFunctionProfile.getFunction());
                        this.trial.getSystemEvents().addObserver(histogramWindow);
                        histogramWindow.show();
                    }
                } else if (string.equals("Show User Event Details")) {
                    if (this.clickedOnObject instanceof PPUserEventProfile) {
                        pPUserEventProfile = (PPUserEventProfile)this.clickedOnObject;
                        this.trial.getColorChooser().setHighlightedUserEvent(pPUserEventProfile.getUserEvent());
                        UserEventWindow userEventWindow = new UserEventWindow(this.trial, pPUserEventProfile.getUserEvent(), this.trial.getStaticMainWindow().getDataSorter());
                        this.trial.getSystemEvents().addObserver(userEventWindow);
                        userEventWindow.show();
                    }
                } else if (string.equals("Change Function Color")) {
                    Function function = null;
                    if (this.clickedOnObject instanceof PPFunctionProfile) {
                        function = ((PPFunctionProfile)this.clickedOnObject).getFunction();
                        Color color = function.getColor();
                        JColorChooser jColorChooser = new JColorChooser();
                        if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                            function.setSpecificColor(color);
                            function.setColorFlag(true);
                            this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                        }
                    }
                } else if (string.equals("Change User Event Color")) {
                    UserEvent userEvent = null;
                    if (this.clickedOnObject instanceof PPUserEventProfile) {
                        userEvent = ((PPUserEventProfile)this.clickedOnObject).getUserEvent();
                    }
                    Color color = userEvent.getColor();
                    JColorChooser jColorChooser = new JColorChooser();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                        userEvent.setSpecificColor(color);
                        userEvent.setColorFlag(true);
                        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                    }
                } else if (string.equals("Reset to Generic Color")) {
                    Function function;
                    if (this.clickedOnObject instanceof PPFunctionProfile) {
                        function = ((PPFunctionProfile)this.clickedOnObject).getFunction();
                        function.setColorFlag(false);
                    }
                    if (this.clickedOnObject instanceof PPUserEventProfile) {
                        function = ((PPUserEventProfile)this.clickedOnObject).getUserEvent();
                        function.setColorFlag(false);
                    }
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            Object var2_2 = null;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = this.trial.getPreferences().getBarHeight();
            int n4 = mouseEvent.getClickCount();
            int n5 = n2 - this.startLocation;
            int n6 = n5 / this.spacing;
            int n7 = (n6 + 1) * this.spacing;
            int n8 = n7 - this.maxFontAscent;
            if (n5 >= n8 && n5 <= n7 && n6 < this.list.size()) {
                if (this.userEventWindow) {
                    PPUserEventProfile pPUserEventProfile = null;
                    pPUserEventProfile = (PPUserEventProfile)this.list.elementAt(n6);
                    if ((mouseEvent.getModifiers() & 0x10) == 0) {
                        this.clickedOnObject = pPUserEventProfile;
                        this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        this.trial.getColorChooser().toggleHighlightedUserEvent(pPUserEventProfile.getUserEvent());
                    }
                } else {
                    PPFunctionProfile pPFunctionProfile = null;
                    pPFunctionProfile = (PPFunctionProfile)this.list.elementAt(n6);
                    if ((mouseEvent.getModifiers() & 0x10) == 0) {
                        this.clickedOnObject = pPFunctionProfile;
                        this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        this.trial.getColorChooser().toggleHighlightedFunction(pPFunctionProfile.getFunction());
                    }
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = bl ? this.getSize() : this.window.getSize();
        dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        return dimension;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize + 10);
    }
}

