/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.Arrays;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.themes.ITheme;

public final class ThemeElementHelper {
    public static void populateRegistry(ITheme theme, FontDefinition[] definitions, IPreferenceStore store) {
        FontDefinition[] copyOfDefinitions = new FontDefinition[definitions.length];
        System.arraycopy(definitions, 0, copyOfDefinitions, 0, definitions.length);
        Arrays.sort(copyOfDefinitions, new IThemeRegistry.HierarchyComparator(definitions));
        int i = 0;
        while (i < copyOfDefinitions.length) {
            FontDefinition definition = copyOfDefinitions[i];
            ThemeElementHelper.installFont(definition, theme, store);
            ++i;
        }
    }

    private static void installFont(FontDefinition definition, ITheme theme, IPreferenceStore store) {
        FontRegistry registry = theme.getFontRegistry();
        String id = definition.getId();
        String key = ThemeElementHelper.createPreferenceKey(theme, id);
        FontData[] prefFont = store != null ? PreferenceConverter.getFontDataArray((IPreferenceStore)store, (String)key) : null;
        FontData[] defaultFont = null;
        defaultFont = definition.getValue() != null ? new FontData[]{StringConverter.asFontData((String)definition.getValue(), (FontData)PreferenceConverter.FONTDATA_DEFAULT_DEFAULT)} : (definition.getDefaultsTo() != null ? registry.bestDataArray(registry.getFontData(definition.getDefaultsTo()), Workbench.getInstance().getDisplay()) : registry.bestDataArray(registry.getFontData(key), Workbench.getInstance().getDisplay()));
        if (prefFont == null || prefFont == PreferenceConverter.FONTDATA_ARRAY_DEFAULT_DEFAULT) {
            prefFont = defaultFont;
        }
        if (defaultFont != null && store != null) {
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (FontData[])defaultFont);
        }
        if (prefFont != null) {
            registry.put(id, prefFont);
        }
    }

    public static void populateRegistry(ITheme theme, ColorDefinition[] definitions, IPreferenceStore store) {
        ColorDefinition[] copyOfDefinitions = new ColorDefinition[definitions.length];
        System.arraycopy(definitions, 0, copyOfDefinitions, 0, definitions.length);
        Arrays.sort(copyOfDefinitions, new IThemeRegistry.HierarchyComparator(definitions));
        int i = 0;
        while (i < copyOfDefinitions.length) {
            ColorDefinition definition = copyOfDefinitions[i];
            ThemeElementHelper.installColor(definition, theme, store);
            ++i;
        }
    }

    private static void installColor(ColorDefinition definition, ITheme theme, IPreferenceStore store) {
        ColorRegistry registry = theme.getColorRegistry();
        String id = definition.getId();
        String key = ThemeElementHelper.createPreferenceKey(theme, id);
        RGB prefColor = store != null ? PreferenceConverter.getColor((IPreferenceStore)store, (String)key) : null;
        RGB defaultColor = null;
        defaultColor = definition.getValue() != null ? definition.getValue() : registry.getRGB(definition.getDefaultsTo());
        if (prefColor == null || prefColor == PreferenceConverter.COLOR_DEFAULT_DEFAULT) {
            prefColor = defaultColor;
        }
        if (defaultColor != null && store != null) {
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (RGB)defaultColor);
        }
        if (prefColor != null) {
            registry.put(id, prefColor);
        }
    }

    public static String createPreferenceKey(ITheme theme, String id) {
        String themeId = theme.getId();
        if (themeId == null) {
            return id;
        }
        return String.valueOf(themeId) + '.' + id;
    }

    private ThemeElementHelper() {
    }
}

