import OPML

class BlogListEntry(object):
    __slots__ = ('text', 'url')

def _find_entries(outline):
    entries = []
    for c in outline.children:
        entries += _find_entries(c)
    type = outline.get('type', '')
    text = outline.get('text', '')
    e = None
    if type == 'link':
        url = outline.get('url', '')
        if url != '':
            e = BlogListEntry()
            e.text = text
            e.url = url
    else:
        xmlurl = outline.get('xmlUrl', '')
        e = BlogListEntry()
        e.text = text
        if text == '':
            title = outline.get('title', '')
            if title == '':
                e = None
            e.text = title
        if e != None:
            if xmlurl != '':
                # there's something in xmlurl. There's a good chance that's
                # our feed's URL
                e.url = xmlurl
            else:
                htmlurl = outline.get('htmlUrl', '')
                if htmlurl != '':
                    # there's something in htmlurl, and xmlurl is empty. This
                    # might be our feed's URL.
                    e.url = htmlurl
                else:
                    # nothing else to try.
                    e = None
    if e is not None:
        entries[0:0] = [e]
    return entries

def find_entries(outlines):
    entries = []
    for o in outlines:
        entries += _find_entries(o)
    return entries

def read(stream):
    try:
        o = OPML.parse(stream)
    except ValueError:
        return None
    entries = find_entries(o.outlines)
    ret = []
    edict = {}
    # avoid duplicates.
    for e in entries:
        ek = (e.text, e.url)
        edict[ek] = edict.get(ek, 0) + 1
        if edict[ek] < 2:
            ret.append(e)
    return ret

