#ifndef __SD_LIB_H__
#define __SD_LIB_H__

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "dictziplib.h"

#include <stdio.h>
#include <gtk/gtk.h>


struct cacheItem
{
	glong offset;
	gchar *data;
	cacheItem();
	~cacheItem();
};

const int WORDDATA_CACHE_NUM = 10;
const int INVALID_INDEX=-100;

class DictBase
{
public:
	DictBase();
	~DictBase();
	gchar * GetWordData(glong idxitem_offset, glong idxitem_size);
protected:
	gchar *sametypesequence;
	FILE *dictfile;
	dictData *dictdzfile;
private:
	struct cacheItem cache[WORDDATA_CACHE_NUM];
	gint cache_cur;	
};

class Lib : public DictBase
{
private:
	glong wordcount;
	gchar *bookname;

	FILE *idxfile;
	
	union {
		gchar **wordlist;
		glong *wordoffset;
	};

#ifdef HAVE_MMAP
	int mmap_fd;
	unsigned long mmap_idxmap_size;
#endif

	union {
		gchar *idxdatabuffer;
		glong cur_wordindex;
	};

	gchar wordentry_buf[256]; // The length of "word_str" should be less than 256. See src/tools/DICTFILE_FORMAT.
	glong wordentry_offset;
	glong wordentry_size;
	
	gboolean load_ifofile(const char *ifofilename, gulong *idxfilesize);

	void loadwordlist();
	void loadwordoffset();
public:
	Lib();
    ~Lib();
	gboolean load(const char *ifofilename);
	inline glong length() { return(wordcount); }
	inline gchar* GetBookname() { return(bookname); }
	gboolean Lookup(const char* sWord,glong *pIndex);
	gboolean LookupWithRule(GPatternSpec *pspec,glong *aIndex,int iBuffLen);
	gchar * GetWord(glong index);
	gchar * GetWordData(glong index);
};

//============================================================================
class Libs
{
private:
	Lib **oLib; // word library.
	gint libcount;
	
	void LoadDir(gchar *dirname, GSList *order_list, GSList *disable_list);
public:
	Libs();
	~Libs();
	void Load();
	glong iLength(int iLib);
	gchar* GetBookname(int iLib);
	inline gint total_libs() { return(libcount); }
	gchar * poGetWord(glong iIndex,int iLib);
	gchar * poGetWordData(glong iIndex,int iLib);
	gchar * poGetCurrentWord(glong * iCurrent);
	gchar * poGetNextWord(const gchar *word,glong * iCurrent);
	gchar * poGetPreWord(glong * iCurrent);
	gboolean LookupWord(const gchar* sWord,glong& iWordIndex,int iLib);
	gboolean LookupSimilarWord(const gchar* sWord,glong& iWordIndex,int iLib);
	gboolean SimpleLookupWord(const gchar* sWord,glong& iWordIndex,int iLib);
	gboolean LookdupWordsWithRule(GPatternSpec *pspec,glong* aiIndexes,int iLen,int iLib);
};

inline gboolean bIsVowel(gchar inputchar);

class TreeDict : public DictBase
{
private:	
	gboolean load_ifofile(const char *ifofilename, gulong *tdxfilesize);
	void load_model(gchar **buffer, GtkTreeStore *model, GtkTreeIter *parent, gint count);
public:
	gboolean load(const char *ifofilename, GtkTreeStore *model);
};

class TreeDicts
{
public:
	TreeDicts();
	~TreeDicts();
	GtkTreeStore* Load();
	gchar * poGetWordData(glong offset, glong size, int iTreeDict);
private:
	TreeDict **oTreeDict;
	gint treedictcount;
	
	void LoadDir(gchar *dirname, GSList *order_list, GSList *disable_list, GtkTreeStore *model);	
};

#endif
