/* @(#)librmt.h	1.16 03/06/15 Copyright 1996 J. Schilling */
/*
 *	Prototypes for rmt client subroutines
 *
 *	Copyright (c) 1995,1996,2000-2002 J. Schilling
 */
/*
 * Copyright Jrg Schilling. All rights reserved.
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only.
 * See the file CDDL.Schily.txt in this distribution or
 * http://opensource.org/licenses/cddl1.php for details.
 */

#ifndef	_LIBRMT_H
#define	_LIBRMT_H

#ifndef _MCONFIG_H
#include <mconfig.h>
#endif
#ifndef _PROTOTYP_H
#include <prototyp.h>
#endif

#ifndef	_INCL_SYS_TYPES_H
#include <sys/types.h>
#define	_INCL_SYS_TYPES_H
#endif

#include <rmtio.h>

/*
 * remote.c
 */
extern	void		rmtinit		__PR((int (*errmsgn)(int, const char *, ...),
						void (*eexit)(int)));
extern	int		rmtdebug	__PR((int dlevel));
extern	char		*rmtfilename	__PR((char *name));
extern	char		*rmthostname	__PR((char *hostname, int hnsize, char *rmtspec));
extern	int		rmtgetconn	__PR((char *host, int trsize, int excode));
extern	int		rmtopen		__PR((int fd, char *fname, int fmode));
extern	int		rmtclose	__PR((int fd));
extern	int		rmtread		__PR((int fd, char *buf, int count));
extern	int		rmtwrite	__PR((int fd, char *buf, int count));
extern	off_t		rmtseek		__PR((int fd, off_t offset, int whence));
extern	int		rmtioctl	__PR((int fd, int cmd, int count));
#ifdef	MTWEOF
extern	int		rmtstatus	__PR((int fd, struct mtget *mtp));
#endif
extern	int		rmtxstatus	__PR((int fd, struct rmtget *mtp));
#ifdef	MTWEOF
extern	void		_rmtg2mtg	__PR((struct mtget *mtp, struct rmtget *rmtp));
extern	int		_mtg2rmtg	__PR((struct rmtget *rmtp, struct mtget *mtp));
#endif

#endif	/* _LIBRMT_H */
