<?php
/**
 * $Horde: forwards/main.php,v 1.1.1.1.2.11 2005/01/03 11:25:43 jan Exp $
 *
 * Copyright 2001-2005 Eric Rostetter <eric.rostetter@physics.utexas.edu>
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/bsdl.php.
 */

define('FORWARDS_BASE', dirname(__FILE__));
include_once FORWARDS_BASE . '/lib/base.php';
require_once FORWARDS_BASE . '/config/conf.php';

// create a driver
require_once FORWARDS_BASE . '/lib/Driver.php';
$driver = &Forwards_Driver::factory($conf['server']['driver'], $conf['server']['params']);

// Get the current login username and realm
$split = explode('@', Auth::getAuth());
$user = @$split[0]; $realm = @$split[1];
if (empty($realm)) {
    $realm = "default";
}

$submit=Horde::getFormData('submit', false);

if ( $submit ) {
    $forwardmode=Horde::getFormData('mode', "error");
    if ($forwardmode === "error") {
        Horde::raiseMessage(_("You must specify the mode (set or remove)"),
                            HORDE_WARNING);
    }

    // Check for refused usernames, using current horde username

    if (in_array($user, $conf['user']['refused'])) {
        $msg=sprintf (_("You can't change Forwards for user %s"), $user);
        Horde::raiseMessage($msg,HORDE_ERROR);
        $forwardmode = "error";
    }
    $oldpassword=Horde::getFormData('oldpassword', false);
    if (!$oldpassword) {
        Horde::raiseMessage(_("You must give your password"),HORDE_WARNING);
        $forwardmode = "error";
    }

    $metoo=Horde::getFormData('metoo', false);
    if ($metoo != "on") {
        $metoo = "off";
    }

    // Do the function requested
    switch ($forwardmode) {

    case "set":
        $forwardwhere=Horde::getFormData('where', false);
        if (!$forwardwhere) {
            Horde::raiseMessage(_("You must supply an e-mail address"),HORDE_WARNING);
        } else {
            if ($driver->enableForwarding($user, $realm, $oldpassword, $forwardwhere, $metoo)) {
                Horde::raiseMessage(_("Forward set!"),HORDE_SUCCESS);
            } else {
                Horde::raiseMessage( _("Failure in setting forward : ") . 
                    $driver->err_str, HORDE_ERROR);
            }
        }
        break;

    case "unset":
        if ($driver->disableForwarding($user, $realm, $oldpassword)) {
            Horde::raiseMessage(_("Forward removed!"),HORDE_SUCCESS);
        } else {
            Horde::raiseMessage( _("Failure in removing forward : ") . 
                    $driver->err_str, HORDE_ERROR);
        }
        break;

    default:
        break;
    }
}

// If we can tell if the forwards are enabled, then say so. But if
// this fails, it could be because it is disabled, or just because we
// can't tell, so just be quiet about it.
if ($driver->isEnabledForwarding($user, $realm, Auth::getCredential('password'))) {
            Horde::raiseMessage( _("Forwarding is currently enabled."),
                    HORDE_ERROR);
}

    include_once $registry->getTemplatePath('horde') . '/javascript/open_help_win.js';
    require $registry->getTemplatePath() . '/common-header.inc';
    require $registry->getFileRoot() . '/status.php';
    require $registry->getTemplatePath() . '/main/javascript.inc';
    require $registry->getTemplatePath() . '/main/main.inc';
    require $registry->getTemplatePath() . '/common-footer.inc';
?>
