/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "../player.h"
#include "../file.h"
#include "../playlist.h"
#include "graphic.h"

void pl_open (GtkFileSelection *, gpointer);

void
add_pl_activate (GtkWidget * w, gpointer data)
{
  GtkWidget *fs;

  fs = gtk_file_selection_new ("Choose your playlist");
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fs));
  gtk_file_selection_set_select_multiple (GTK_FILE_SELECTION (fs), FALSE);
  gtk_file_selection_complete (GTK_FILE_SELECTION (fs), "*.pls");

  gtk_widget_show (fs);

  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fs)->ok_button),
		      "clicked", GTK_SIGNAL_FUNC (pl_open), (gpointer) fs);
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (fs)->ok_button),
			     "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     (gpointer) fs);

  gtk_signal_connect_object (GTK_OBJECT
			     (GTK_FILE_SELECTION (fs)->cancel_button),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     (gpointer) fs);
}

void
pl_open (GtkFileSelection * fs, gpointer user_data)
{
  char *filename;

  if (!user_data)
    return;

  filename =
    (char *) gtk_file_selection_get_filename (GTK_FILE_SELECTION (user_data));

  if (!filename)
    return;

  if (playlist_read (filename))
    dialog_msg ("I can't open your playlist.");
}

/* EOF */
