/*
 * $Id: gtkledbar.c,v 1.6 2002/03/06 00:14:03 iain Exp $
 * GTKEXT - Extensions to The GIMP Toolkit
 * Copyright (C) 1998 Gregory McLean
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Cambridge, MA 
 * 02139, USA.
 *
 * Eye candy!
 */

/*
 * DeGNOMEization and fixes - 2002/07/06 Carlos Rodrigues <cer09566@students.fct.unl.pt>
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/* #include <libgnome/gnome-macros.h> */
#include <gtk/gtktable.h>

#include "gtkledbar.h"

static void gtk_led_bar_class_init (GtkLedBarClass * klass);
static void gtk_led_bar_instance_init (GtkLedBar * gtk_led_bar);

/*
GNOME_CLASS_BOILERPLATE (GtkLedBar, gtk_led_bar,
			 GtkVBox, GTK_TYPE_VBOX);
*/

GType
gtk_led_bar_get_type ()
{
  static GType gtk_led_bar_type = 0;

  if (!gtk_led_bar_type)
    {
      static const GTypeInfo gtk_led_bar_info = {
	sizeof (GtkLedBarClass),
	NULL,
	NULL,
	(GClassInitFunc) gtk_led_bar_class_init,
	NULL,
	NULL,
	sizeof (GtkLedBar),
	0,
	(GInstanceInitFunc) gtk_led_bar_instance_init,
      };

      gtk_led_bar_type =
	g_type_register_static (GTK_TYPE_VBOX, "GtkLedBar", &gtk_led_bar_info,
				0);
    }

  return gtk_led_bar_type;
}

static void
gtk_led_bar_class_init (GtkLedBarClass * class)
{
}

static void
gtk_led_bar_instance_init (GtkLedBar * gtk_led_bar)
{
  gtk_led_bar->num_segments = 0;
  gtk_led_bar->lit_segments = 0;
  gtk_led_bar->seq_segment = 0;
  gtk_led_bar->seq_dir = 1;
}

GtkWidget *
gtk_led_bar_new (gint segments, gint orientation)
{
  GtkLedBar *gtk_led_bar;
  GtkWidget *table;
  gint i;
  GdkColor active;
  GdkColor inactive;
  gint half, full;

  gtk_led_bar = g_object_new (gtk_led_bar_get_type (), NULL);
  if (segments > MAX_SEGMENTS)
    {
      segments = MAX_SEGMENTS;
    }

  gtk_led_bar->num_segments = segments;
  gtk_led_bar->orientation = orientation;

  if (!orientation)
    {				/* horiz */
      table = gtk_table_new (1, segments, FALSE);
    }
  else
    {				/* vert */
      table = gtk_table_new (segments, 1, FALSE);
    }

  gtk_container_add (GTK_CONTAINER (gtk_led_bar), table);
  gtk_widget_show (table);

  half = .50 * segments;
  full = .75 * segments;

  gdk_color_parse ("#00F100", &active);
  gdk_color_parse ("#008C00", &inactive);

  for (i = 0; i < segments; i++)
    {
      if (i >= half && i <= full)
	{
	  gdk_color_parse ("#F1EE00", &active);
	  gdk_color_parse ("#8CAA00", &inactive);
	}
      else
	{
	  if (i >= full)
	    {
	      gdk_color_parse ("#F10000", &active);
	      gdk_color_parse ("#8C0000", &inactive);
	    }
	}

      gtk_led_bar->segments[i] = gtk_led_new ();
      gtk_led_set_colors (GTK_LED (gtk_led_bar->segments[i]), &active,
			  &inactive);

      if (!orientation)
	{			/* horiz */
	  gtk_table_attach (GTK_TABLE (table), gtk_led_bar->segments[i],
			    i, (i + 1), 0, 1, 0, 0, 0, 0);
	}
      else
	{			/* vert */
	  gtk_table_attach (GTK_TABLE (table), gtk_led_bar->segments[i],
			    0, 1, (segments - i - 1), (segments - i),
			    0, 0, 0, 0);
	}

      gtk_widget_show (gtk_led_bar->segments[i]);
    }

  return GTK_WIDGET (gtk_led_bar);
}

gint
gtk_led_bar_get_num_segments (GtkWidget * bar)
{
  g_return_val_if_fail (IS_GTK_LED_BAR (bar), 0);

  return GTK_LED_BAR (bar)->num_segments;
}

gint
gtk_led_bar_last_lit_segment (GtkWidget * bar)
{
  g_return_val_if_fail (IS_GTK_LED_BAR (bar), -2);

  return GTK_LED_BAR (bar)->lit_segments - 1;
}

void
gtk_led_bar_light_segments (GtkWidget * bar, gint num)
{
  GtkLedBar *gtk_led_bar;
  int i;

  g_return_if_fail (IS_GTK_LED_BAR (bar));

  gtk_led_bar = GTK_LED_BAR (bar);
  if (num == 0 && gtk_led_bar->lit_segments == 0)
    {
      return;
    }

  if (num < gtk_led_bar->lit_segments)
    {
      for (i = 0; i < num; i++)
	{
	  gtk_led_set_state (GTK_LED (gtk_led_bar->segments[i]),
			     GTK_STATE_SELECTED, TRUE);
	}
    }
  else
    {
      for (i = gtk_led_bar->lit_segments; i < num; i++)
	gtk_led_set_state (GTK_LED (gtk_led_bar->segments[i]),
			   GTK_STATE_SELECTED, TRUE);
    }

  gtk_led_bar->lit_segments = i;
}

void
gtk_led_bar_unlight_segments (GtkWidget * bar, gint num)
{
  GtkLedBar *gtk_led_bar;
  int i;

  g_return_if_fail (IS_GTK_LED_BAR (bar));

  gtk_led_bar = GTK_LED_BAR (bar);
  if (gtk_led_bar->lit_segments == 0)
    {
      return;
    }

  for (i = 0; i < num; i++)
    {
      gtk_led_set_state (GTK_LED (gtk_led_bar->segments[i]),
			 GTK_STATE_SELECTED, FALSE);
    }

  gtk_led_bar->lit_segments -= num;

  if (gtk_led_bar->lit_segments < 0)
    {
      gtk_led_bar->lit_segments = 0;
    }
}

void
gtk_led_bar_light_segment (GtkWidget * bar, gint segment)
{
  GtkLedBar *gtk_led_bar;

  g_return_if_fail (IS_GTK_LED_BAR (bar));

  gtk_led_bar = GTK_LED_BAR (bar);
  gtk_led_set_state (GTK_LED (gtk_led_bar->segments[segment]),
		     GTK_STATE_SELECTED, TRUE);
}

void
gtk_led_bar_unlight_segment (GtkWidget * bar, gint segment)
{
  GtkLedBar *gtk_led_bar;

  g_return_if_fail (IS_GTK_LED_BAR (bar));

  gtk_led_bar = GTK_LED_BAR (bar);
  gtk_led_set_state (GTK_LED (gtk_led_bar->segments[segment]),
		     GTK_STATE_SELECTED, FALSE);
}

void
gtk_led_bar_light_percent (GtkWidget * bar, gfloat percent)
{
  GtkLedBar *gtk_led_bar;
  gint num, i;

  g_return_if_fail (IS_GTK_LED_BAR (bar));

  gtk_led_bar = GTK_LED_BAR (bar);
  num = (percent / 100) * gtk_led_bar->num_segments;

  gtk_led_bar->lit_segments = num;
  for (i = 0; i < gtk_led_bar->num_segments; i++)
    {
      if (num > 0)
	{
	  if (!(GTK_LED (gtk_led_bar->segments[i])->is_on))
	    {
	      gtk_led_set_state (GTK_LED (gtk_led_bar->segments[i]),
				 GTK_STATE_SELECTED, TRUE);
	    }

	  num--;
	}
      else
	{
	  if (GTK_LED (gtk_led_bar->segments[i])->is_on)
	    {
	      gtk_led_set_state (GTK_LED (gtk_led_bar->segments[i]),
				 GTK_STATE_SELECTED, FALSE);
	    }
	}
    }
}

void
gtk_led_bar_clear (GtkWidget * bar)
{
  GtkLedBar *gtk_led_bar;
  int i;

  g_return_if_fail (IS_GTK_LED_BAR (bar));

  gtk_led_bar = GTK_LED_BAR (bar);
  for (i = 0; i < gtk_led_bar->num_segments; i++)
    {
      if (GTK_LED (gtk_led_bar->segments[i])->is_on)
	{
	  gtk_led_set_state (GTK_LED (gtk_led_bar->segments[i]),
			     GTK_STATE_SELECTED, FALSE);
	}
    }
}

void
gtk_led_bar_sequence_step (GtkWidget * bar)
{
  GtkLedBar *gtk_led_bar;

  g_return_if_fail (IS_GTK_LED_BAR (bar));

  gtk_led_bar = GTK_LED_BAR (bar);

  if (gtk_led_bar->seq_segment >= (gtk_led_bar->num_segments - 1))
    {
      gtk_led_bar->seq_dir = -1;
    }
  else if (gtk_led_bar->seq_segment <= 0)
    {
      gtk_led_bar->seq_dir = 1;
    }

  gtk_led_bar_unlight_segment (GTK_WIDGET (gtk_led_bar),
			       gtk_led_bar->seq_segment);
  gtk_led_bar->seq_segment += gtk_led_bar->seq_dir;
  gtk_led_bar_light_segment (GTK_WIDGET (gtk_led_bar),
			     gtk_led_bar->seq_segment);
}

/* EOF */
