/*
 * The Sleuth Kit
 *
 * $Date: 2005/01/17 22:40:17 $
 *
 * Brian Carrier [carrier@sleuthkit.org]
 * Copyright (c) 2003-2005 Brian Carrier.  All rights reserved
 * 
 * Copyright (c) 1997,1998,1999, International Business Machines          
 * Corporation and others. All Rights Reserved.
 *
 *
 * LICENSE
 *	This software is distributed under the IBM Public License.
 * AUTHOR(S)
 *	Wietse Venema
 *	IBM T.J. Watson Research
 *	P.O. Box 704
 *	Yorktown Heights, NY 10598, USA
--*/

#include <errno.h>
#include "mm_tools.h"


/* mm_read_block - read a block given the address - calls the read_random at the img layer */

OFF_T
mm_read_block(MM_INFO * mm, DATA_BUF * buf, OFF_T len, DADDR_T addr)
{
    OFF_T ofmm, cnt;

    if (len % mm->dev_bsize) {
	if (verbose)
	    fprintf(logfp,
		    "mm_read_block: Block read request with length (%"
		    PRIuOFF ") not a multiple of %d", len, mm->dev_bsize);
	errno = EIO;
	return 0;
    }


    if (len > buf->size) {
	if (verbose)
	    fprintf(logfp,
		    "mm_read_block: Buffer length is too short for read (%"
		    PRIuOFF " > %Zd)", len, buf->size);

	errno = EIO;
	return 0;
    }

    buf->addr = addr;
    ofmm = (OFF_T) addr *mm->block_size;

    cnt = mm->img_info->read_random(mm->img_info, buf->data, len, ofmm);
    buf->used = cnt;
    return cnt;
}

OFF_T
mm_read_block_nobuf(MM_INFO * mm, char *buf, OFF_T len, DADDR_T addr)
{
    if (len % mm->dev_bsize) {
	if (verbose)
	    fprintf(logfp,
		    "mm_read_block_nobuf: Block read request with length (%"
		    PRIuOFF ") not a multiple of %d", len, mm->dev_bsize);
	errno = EIO;
	return 0;
    }

    return mm->img_info->read_random(mm->img_info, buf, len,
				     (OFF_T) addr * mm->block_size);
}
