# This code is a part of Slash, and is released under the GPL.
# Copyright 1997-2001 by Open Source Development Network. See README
# and COPYING for more information, or see http://slashcode.com/.
# $Id: FZ.pm,v 1.1.2.5 2001/10/19 22:18:11 pudge Exp $

package Slash::XML::FZ;

=head1 NAME

Slash::XML::FZ - Perl extension for Slash


=head1 SYNOPSIS

	use Slash::XML;
	xmlDisplay(%data);


=head1 DESCRIPTION

LONG DESCRIPTION.


=head1 EXPORTED FUNCTIONS

=cut

use strict;
use Slash;
use Slash::Utility;
use XML::RSS;
use base 'Slash::XML';
use vars qw($VERSION);

($VERSION) = ' $Revision: 1.1.2.5 $ ' =~ /\$Revision:\s+([^\s]+)/;

sub create {
	my($class, $param) = @_;
	my $self = bless {}, $class;

	$param ||= {};

	my $xml = $self->fzHeader();

	if (!$param->{type} || $param->{type} eq 'forum') {
		$xml .= $self->fzDescribeForum($param);
	} elsif ($param->{type} eq 'story') {
		$xml .= $self->fzDescribeStory($param);
	}

	$xml .= $self->fzFooter();

	return $xml;
}


########################################################
sub fzHeader {
	return <<EOT;
<?xml version="1.0" encoding="UTF-8"?>

<rdf:RDF
 xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
 xmlns="http://purl.org/rss/1.0/"
 xmlns:fz="http://www.zapogee.com/rdf/forumzilla/"
>

EOT
}


########################################################
sub fzFooter {
	return <<EOT;
</rdf:RDF>
EOT
}

########################################################
sub fzDescribeForum {
	my($self, $param) = @_;
	my $constants = getCurrentStatic();
	my $slashdb   = getCurrentDB();

	my($xml, $sxml);
	my $url      = $constants->{absolutedir};
	my $stories  = $param->{stories};
	my $section  = $param->{section};

	# set defaults
	my %forum = (
		title		=> $constants->{sitename},
		'link'		=> $url . '/',
	);

	my $SECT = $slashdb->getSection($section);
	if ($section) {
		$forum{'link'} = "$url/index.pl?section=$section";
		$forum{title} = "$constants->{sitename}: $SECT->{title}"
			unless $SECT->{isolate};
	}

	for (keys %forum) {
		$forum{$_} = $self->encode($forum{$_}, $_);
	}

	# start building the RDF description of this forum
	$xml = <<EOT;
  <fz:forum rdf:about="$forum{'link'}">
    <fz:title>$forum{title}</fz:title>
    <fz:navigation rdf:resource="$url/fz.pl?op=navbar" />
EOT

	$xml .= <<EOT if $constants->{run_ads};  # fix later
    <fz:ads resource="$url/fz.pl?op=ad" />
EOT


	# start the list of articles
	$xml .= <<EOT;

    <fz:articles>
      <rdf:Seq>
EOT

	for my $story (@$stories) {
		my($link, $desc, $title, $date, $ldate, $numc);
		$link  = $self->encode("$url/fz.pl?sid=$story->{sid}&op=displayStory",  'link');  # fix later
		$desc  = $self->encode("$url/fz.pl?sid=$story->{sid}&op=describeStory", 'link');  # fix later
		$title = $self->encode($story->{title});
		$date  = $self->date2iso8601($story->{'time'});
		$ldate = $self->date2iso8601($story->{lastcommentdate})
			if $story->{lastcommentdate};
		$numc  = $story->{commentcount} || 0;

		$xml .= <<EOT;
        <rdf:li rdf:resource="$link" />
EOT

		$sxml .= <<EOT;
  <fz:story rdf:about="$link">
    <fz:title>$title</fz:title>
    <fz:description rdf:resource="$desc" />
    <fz:date>$date</fz:date>
EOT
		$sxml .= <<EOT if $ldate;
    <fz:lastcommentdate>$ldate</fz:lastcommentdate>
EOT
		$sxml .= <<EOT;
    <fz:numcomments>$numc</fz:numcomments>
  </fz:story>

EOT
	}

	# end the list of articles and the channel description
	$xml .= <<EOT;
      </rdf:Seq>
    </fz:articles>
  </fz:forum>

EOT

	# add the items to the text
	$xml .= $sxml;

	return $xml;
}

########################################################"
sub fzDescribeReplies {
	my($self, $comments, $pid, $sid) = @_;

	my $url = getCurrentStatic('absolutedir');
	my $xml = <<EOT;
    <fz:replies>
      <rdf:Seq>
EOT

	for my $cid (@{$comments->{$pid}{kids}}) {
		my $comment = $comments->{$cid};
		next if $comment->{pid} ne $pid;
		my $link = $self->encode("$url/fz.pl?sid=$sid&cid=$comment->{cid}&op=displayComment", 'link');
		$xml .= <<EOT;
        <rdf:li resource="$link" />
EOT
	}

	$xml .= <<EOT;
      </rdf:Seq>
    </fz:replies>
EOT
}

########################################################
sub fzDescribeStory {
	my($self, $param) = @_;
	my $constants = getCurrentStatic();
	my $slashdb   = getCurrentDB();

	my($xml, $cxml);
	my $url      = $constants->{absolutedir};
	my $sid      = $param->{sid};
	my $section  = $param->{section};
	my $comments = $param->{comments};

	my $link  = $self->encode("$url/fz.pl?sid=$sid&op=displayStory", 'link');
	$xml = <<EOT;
  <fz:story rdf:about="$link">
    <fz:comments>
      <rdf:Seq>
EOT

	for my $cid (sort { $a <=> $b } keys %$comments) {
		my $comment = $comments->{$cid};
		next unless $comment->{cid};
		my $link  = $self->encode("$url/fz.pl?sid=$sid&cid=$comment->{cid}&op=displayComment", 'link');  # fix later
		my $date  = $self->date2iso8601($comment->{date});
		my $user  = $comment->{nickname};
		my $pts   = $comment->{points};
		(my $title = $comment->{subject}) =~ s/^Re:? ?//i;
		my $score = "(Score: $pts";
		$score .= ", $constants->{reasons}[$comment->{reason}]"
			if $comment->{reason};  # eschew "0"
		$score .= ")";

		for ($user, $pts, $title, $score) {
			$_ = $self->encode($_);
		}

		$xml .= <<EOT;
        <rdf:li rdf:resource="$link" />
EOT

		$cxml .= <<EOT;
  <fz:comment about="$link">
    <fz:title>$title</fz:title>
    <fz:author>$user</fz:author>
    <fz:datetime>$date</fz:datetime>
    <fz:score>$score</fz:score>
    <fz:points>$pts</fz:points>
EOT

		if ($comment->{kids}) {
			$cxml .= $self->fzDescribeReplies($comments, $comment->{cid}, $sid);
		}

		$cxml .= <<EOT;
  </fz:comment>

EOT
	}

	$xml .= <<EOT;
      </rdf:Seq>
    </fz:comments>

EOT

	$xml .= $self->fzDescribeReplies($comments, 0, $sid);

	$xml .= <<EOT;
  </fz:story>
EOT

	$xml .= $cxml;
	return $xml;
}


1;

__END__


=head1 SEE ALSO

Slash(3), Slash::XML(3).

=head1 VERSION

$Id: FZ.pm,v 1.1.2.5 2001/10/19 22:18:11 pudge Exp $
