/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "options.h"
#include "common.h"

#include <string.h>

struct args_def args_list[] = {
  {"remove",'r',ARGS_PARAM_NONE},
  {"send",'s',ARGS_PARAM_NONE},
  {"get",'g',ARGS_PARAM_NONE},

  {"bitmap",'B',ARGS_PARAM_OPT}, //deprecated
  {"midi",'M',ARGS_PARAM_OPT}, //deprecated
  {"vcal",'C',ARGS_PARAM_OPT}, //deprecated
  {"vcard",'F',ARGS_PARAM_OPT}, //deprecated

  {"binary",'N',ARGS_PARAM_NONE},
  {"pbook",'P',ARGS_PARAM_NONE},
  {"sms",'S',ARGS_PARAM_OPT}, //parameter is deprecated

  {"info",'i',ARGS_PARAM_NONE},
  {"mem-info",0,ARGS_PARAM_NONE},
  {"lock-info",0,ARGS_PARAM_NONE},
  {"set-time",0,ARGS_PARAM_NONE},
  {"set-smsc",0,ARGS_PARAM_NONE},
  {"toggle-lock",0,ARGS_PARAM_REQ}, //since 0.7.4
  {"dial",0,ARGS_PARAM_NONE}, //since 0.7.4
  {"reset",0,ARGS_PARAM_NONE},

  {"mem",0,ARGS_PARAM_REQ},
  {"slot",0,ARGS_PARAM_REQ},
  {"smsmem",0,ARGS_PARAM_REQ}, //deprecated
  {"text",'t',ARGS_PARAM_REQ},
  {"unicode",0,ARGS_PARAM_NONE},
  {"number",'n',ARGS_PARAM_REQ},
  {"flash",0,ARGS_PARAM_NONE},
  {"srr",0,ARGS_PARAM_NONE},
  {"direct",0,ARGS_PARAM_NONE},
  {"sort",0,ARGS_PARAM_REQ}, //since 0.7.3
  {"system-charset",0,ARGS_PARAM_REQ}, //since 0.7.5
  {"pin",0,ARGS_PARAM_REQ},

  {"device",'d',ARGS_PARAM_REQ},
  {"baud",'b',ARGS_PARAM_REQ},
  {"device-timeout",0,ARGS_PARAM_REQ},
  {"ignore-serial-bits",0,ARGS_PARAM_NONE},
  {"keep-serial-bits",0,ARGS_PARAM_NONE},
  {"start-delay",0,ARGS_PARAM_REQ},

  {"out",'o',ARGS_PARAM_REQ},
  {"pipe",'p',ARGS_PARAM_REQ},

  {"verbose",'v',ARGS_PARAM_NONE},
  {"quiet",'q',ARGS_PARAM_NONE},
  {"help",'h',ARGS_PARAM_NONE},
  {"version",0,ARGS_PARAM_NONE},
  ARGS_DEF_LAST
};

void args_init (struct args_t* args) {
  args->port.device = NULL;
  args->port.baud = NULL;
  args->port.timeout = 100;
  args->port.ignorebits = 1;
  args->port.startdelay = 0;

  args->myparams.text=NULL;
  args->myparams.number=NULL;
  args->myparams.mem=NULL;
  args->myparams.slot=SCMXX_SLOT_UNDEFINED;

  args->mysmsopts.flash=0;
  args->mysmsopts.srr=0;
  args->mysmsopts.unicode=0;
  args->mysmsopts.direct=0;
  args->mysmsopts.sort_mode=NULL;

  args->scmxx_action=0;
  args->scmxx_ftype=0;

  args->myFILE=NULL;
  args->myPIPE=NULL;

  args->info = 0;
  args->meminfo = 0;
  args->lockinfo = 0;
  args->time = 0;
  args->lock = NULL;
  args->smsc = 0;
  args->dial = 0;
  args->reset = 0;
  args->help = 0;
  args->version = 0;

  args->verbose = 0;
  args->pin = NULL;
  args->system_charset = NULL;
}

#include "helper.h"

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

void arg_fill_slot (char* argument, struct args_t* args) {
  if (is_number(argument)) {
    args->myparams.slot = atoi(argument);
  } else {
    if(!strcmp(argument,"all")) {
      args->myparams.slot = SCMXX_SLOT_ALL;
    } else if(!strcmp(argument,"sent")) {
      args->myparams.slot = SCMXX_SLOT_SMS_SENT;
    } else if(!strcmp(argument,"unsent")) {
      args->myparams.slot = SCMXX_SLOT_SMS_UNSENT;
    } else if(!strcmp(argument,"read")) {
      args->myparams.slot = SCMXX_SLOT_SMS_READ;
    } else if(!strcmp(argument,"unread")) {
      args->myparams.slot = SCMXX_SLOT_SMS_UNREAD;
    } else if (!strcmp(argument,"last")) {
      args->myparams.slot = SCMXX_SLOT_LAST;
    } else {
      args->myparams.slot = SCMXX_SLOT_UNDEFINED;
    }
  }
}

void arg_fill (int short_opt, const char* long_opt,
	       char* argument, struct args_t* args) {
  int temp;

  switch (short_opt) {
  case 'd': //--device
    args->port.device = argument;
    break;
  case 'b': //--baud
    args->port.baud = argument;
    break;
  case 't':
    if (str_len(argument)) args->myparams.text=argument;
    break;
  case 'n':
    if (str_len(argument)) args->myparams.number=argument;
    break;
  case 'o':
    args->myFILE=argument;
    break;
  case 'p':
    args->myPIPE=argument;
    break;
  case 'v':
    args->verbose++;
    break;
  case 'q':
    args->verbose--;
    break;
  case 'h':
    args->help=1;
    break;
  case 'r':
    args->scmxx_action |= SCMXX_ACTION_REMOVE;
    break;
  case 's': 
    args->scmxx_action |= SCMXX_ACTION_SEND;
    break;
  case 'g':
    args->scmxx_action |= SCMXX_ACTION_GET;
    break;
  case 'i':
    args->info=1;
    break;
  case 'B': //old, compat
  case 'M': //old, compat
  case 'C': //old, compat
  case 'F': //old, compat
    args->myparams.mem = NULL;
    switch (short_opt) {
    case 'B':
      args->myparams.mem = "bmp";
      break;
    case 'M':
      args->myparams.mem = "mid";
      break;
    case 'C':
      args->myparams.mem = "vcs";
      break;
    case 'F':
      args->myparams.mem = "vcf";
      break;
    }
    if (argument) {
      arg_fill_slot(argument,args);
    }
    //no break
  case 'N':
    args->scmxx_ftype = SCMXX_FTYPE_BINARY;
    break;
  case 'P':
    args->scmxx_ftype = SCMXX_FTYPE_PBOOK;
    if (argument) { //old, compat
      args->myparams.mem=argument;
    }
    break;
  case 'S':
    args->scmxx_ftype = SCMXX_FTYPE_SMS;
    if (argument) { //old, compat
      arg_fill_slot(argument,args);
    }
    break;
  case 0:
    if (str_len(long_opt)) {
      if (!strcmp(long_opt,"pin")) {
	args->pin = argument;
      } else if (!strcmp(long_opt,"unicode")) {
	args->mysmsopts.unicode=1;
      } else if (!strcmp(long_opt,"direct")) {
	args->mysmsopts.direct=1;
      } else if (!strcmp(long_opt,"srr")) {
	args->mysmsopts.srr=1;
      } else if (!strcmp(long_opt,"flash")) {
	args->mysmsopts.flash=1;
      } else if (!strcmp(long_opt,"version")) {
	args->version=1;
      } else if (!strcmp(long_opt,"ignore-serial-bits")) {
	args->port.ignorebits=1;
      } else if (!strcmp(long_opt,"keep-serial-bits")) {
	args->port.ignorebits=0;
      } else if (!strcmp(long_opt,"device-timeout")) {
	if (argument) {
	  temp = atoi(argument);
	  if (temp < 1) {
	    args->port.timeout = 10;
	  } else if (1 <= temp && temp <= 25) {
	    args->port.timeout = 10*temp;
	  } else if (temp > 25) {
	    args->port.timeout = 0;
	  }
	}
      } else if (!strcmp(long_opt,"start-delay")) {
	args->port.startdelay = atoi(argument);
      } else if (!strcmp(long_opt,"reset")) {
	args->reset=1;
      } else if (!strcmp(long_opt,"set-time")) {
	args->time=1;
      } else if (!strcmp(long_opt,"set-smsc")) {
	args->smsc=1;
      } else if (!strcmp(long_opt,"toggle-lock")) {
	args->lock=argument;
      } else if (!strcmp(long_opt,"dial")) {
	args->dial=1;
      } else if (!strcmp(long_opt,"smsmem")) { //old, compat
	args->myparams.mem = argument;
      } else if (!strcmp(long_opt,"mem")) {
	args->myparams.mem = argument;
      } else if (!strcmp(long_opt,"slot")) {
	arg_fill_slot(argument,args);
      } else if (!strcmp(long_opt,"mem-info")) {
	args->meminfo = 1;
      } else if (!strcmp(long_opt,"lock-info")) {
	args->lockinfo = 1;
      } else if (!strcmp(long_opt,"sort")) { //old, compat
	args->mysmsopts.sort_mode = argument;
      } else if (!strcmp(long_opt,"system-charset")) {
	args->system_charset = argument;
      }
    }
    break;
  }
}

#include "config.h"

void use_envvars (struct args_t* args) {
  //using env. var. SCMXX_BAUD
  if (str_len(args->port.baud) == 0 &&
      (args->port.baud=getenv("SCMXX_BAUD")) == NULL) {
    args->port.baud = TTYSPEED;
  }
  //using env. var. SCMXX_TTY
  if (str_len(args->port.device) == 0 &&
      (args->port.device=getenv("SCMXX_TTY")) == NULL) {
    args->port.device = TTYPORT;
  }
}
