/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "smspdu.h"
#include "memtypes.h"
#include "options.h"
#include "timeincl.h"

#include <stdlib.h>

int VERBOSE_LEVEL;
#define errexit(m, ...) { fprintf(stderr,m,__VA_ARGS__);exit(EXIT_FAILURE); }
#define myprintf(l,m, ...) { if (l<=VERBOSE_LEVEL) fprintf(stderr,m,__VA_ARGS__); }

//from keypad.c
void keypad_dial_number (char* number);

//from lock.c
void lock_toggle (const char* lock, const char* password);
void lock_print_list (FILE* fd, unsigned int full);

//from fileaccess.c
int file_accessible_ro (char* file);
int open_myFile_ro(char* file);
int open_myFile_rw(char* file);
void close_myFile(int filedes);

//from action.c
int phone_init (void);
int command_echo (int enable);
int verbose_errors (int enable);
int pbook_select_mem (char* mem);
int sms_select_mem (char* mem, struct slot_range* r,
		    int* current_fill);
void set_smsc (char* smsnr);
void set_time ();
int  set_charset(char *charset);
char* get_vendor ();
char* get_model ();
char* get_revision ();
char* get_phoneserial ();
char* get_simserial ();
char* get_simid ();
char* get_operator ();
char* get_smsc ();
char* get_charset ();
char* get_battery ();
char* get_signal_ber ();
struct tm* get_time ();
char* get_netstatus (unsigned int* areacode_p, unsigned int* cellid_p);
void info (char* file, int misc, int mem, int lock);

//from s35_files.c
void file_transfer_manage (int   action, char** files,
			   char* outfile, char* pipe,
			   char* mem, int slot);
void file_delete (char* ftype, int slot);
int file_detect_free_slot (char* ftype, int minimum, int maximum);
void file_send (char* file, char* ftype, int slot);
void file_get (char* file, char* ftype, int slot, char* pipe);

//from s35_pbook.c
void pbook_manage (int action, char* outfile,
		   char** files, struct parameters* myparams);
int pbook_get_ranges (char* mem, int write, int* min, int* max, int* nrlen, int* txtlen);

//from s35_sms.c
void sms_manage (int action, char** files,
		 char* outfile, char* pipe,
		 struct parameters* myparams,
		 struct smsopts* mysmsopts);
void sms_delete_slot (int smsslot);
void sms_delete_all (struct sms_slot_data** slist);
void sms_send_slot (int smsslot, char* smsnumber);
void sms_send_pdu (char* pdu, int direct);
void sms_send_pdu_all (struct sms_slot_data** slist, char* number, int direct);
char* sms_pdu_create (char* file, char* text, char* number,
		      struct smsopts* mysmsopts);
int sms_get (struct sms_slot_data** slist, size_t ssize, int slot, int mark_read);
void sms_print (FILE* filefd, char* pipe, struct sms* data);
void sms_print_all (char* file, char* pipe, struct sms_slot_data** slist,
		    char* sort_mode);
void sms_get_direct (char* file, char* pipe);
