/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <atcommand.h>
#include <common.h>
#include <helper.h>
#include <intincl.h>

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <strings.h>
#include <errno.h>
#include <unistd.h>

char* at_gen_keypad (char* keylist, uint8_t duration, uint8_t pause)
{
  char* parmlist;
  char* current_keys = NULL;
  char* retval = NULL;
  unsigned int i = 0;

  if (str_len(keylist) == 0 || duration == 0) return NULL;

  for (; keylist[i] != 0; ++i) {
    if (keylist[i] == '+') {
      if (i == 0) {
	// replace '+' with '0' and
	// make duration at least 10 to get the '+'
	current_keys = str_dup("0");
	if (duration < 10) duration = 10;
/* 	if (pause < 10) pause = 10; */
      } else {
	// Since '+' needs special processing (see above)
	//   process all keys just before the '+'.
	// The '+' will then be processed by the next call
	//   to this function.
	current_keys = strn_dup(keylist,i);
      }
      retval = keylist + strlen(current_keys);
      break;
    }
  }
  if (current_keys == NULL) current_keys = str_dup(keylist);
  parmlist = mem_alloc(1+strlen(current_keys)+1
		       +1+numlen(duration)
		       +1+numlen(pause)+1,1);
  sprintf(parmlist,"\"%s\",%u,%u",current_keys,duration,pause);
  mem_realloc(current_keys,0);
  at_command_send(AT_GEN_KEYPAD,parmlist);
  mem_realloc(parmlist,0);

  // at least the S55 needs some time after an '+'
  if (keylist[0] == '+') sleep(1);
  return retval;
}

void at_gen_password (const char* lock,
		      const char* oldpin,
		      const char* newpin)
{
  char* parmlist;

  if (str_len(lock) == 0 ||
      (oldpin == NULL && newpin == NULL))
    return;
  parmlist = mem_alloc(1+strlen(lock)+3+str_len(oldpin)+3
		       +str_len(newpin)+1,1);
  if (oldpin == NULL) {
    //there is no pin set, yet
    sprintf(parmlist,"\"%s\",,\"%s\"",lock,newpin);
  } else {
    if (newpin == NULL) {
      //delete the pin
      sprintf(parmlist,"\"%s\",\"%s\"",lock,oldpin);
    } else {
      sprintf(parmlist,"\"%s\",\"%s\",\"%s\"",lock,oldpin,newpin);
    }
  }
  at_command_send(AT_GEN_PASSWORD,parmlist);
  mem_realloc(parmlist,0);
}

void at_gen_lock (const char* lock, int mode,
		  const char* password, uint8_t class)
{
  char* parmlist;

  if (str_len(lock) == 0) return;
  parmlist = mem_alloc(1+strlen(lock)+1
		       +1+numlen(mode)
		       +2+str_len(password)+1
		       +1+numlen(class)+1,1);
  if (class > 0)
    if (str_len(password))
      sprintf(parmlist,"\"%s\",%d,\"%s\",%d",lock,mode,password,class);
    else
      sprintf(parmlist,"\"%s\",%d,,%d",lock,mode,class);
  else
    if (str_len(password))
      sprintf(parmlist,"\"%s\",%d,\"%s\"",lock,mode,password);
    else
      sprintf(parmlist,"\"%s\",%d",lock,mode);
  at_command_send(AT_GEN_LOCK,parmlist);
  mem_realloc(parmlist,0);
}

void at_gen_phonebook_write (unsigned int slot,
			     const char* number,
			     unsigned int numtype,
			     const char* text)
{
  char* parmlist;

  parmlist = mem_alloc(numlen(slot)+1
		       +1+str_len(number)+1
		       +1+numlen(numtype)+1
		       +1+str_len(text)+1
		       +1,
		       1);
  if (str_len(number) == 0 && str_len(text) == 0) {
    sprintf(parmlist,"%d",slot);
  } else {
    if (number == NULL) {
      sprintf(parmlist,"%d,\"\",%d,\"%s\"",
	      slot,numtype,text);
    } else if (text == NULL) {
      sprintf(parmlist,"%d,\"%s\",%d,\"\"",
	      slot,number,numtype);
    } else {
      sprintf(parmlist,"%d,\"%s\",%d,\"%s\"",
	      slot,number,numtype,text);
    }
  }
  at_command_send(AT_GEN_PB_WRITE,parmlist);
  mem_realloc(parmlist,0);
}

void at_gen_phonebook_read (unsigned int slot_low,
			    unsigned int slot_high)
{
  char* parmlist;

  parmlist = mem_alloc(numlen(slot_low)+1
		       +numlen(slot_high)+1, 1);
  sprintf(parmlist,"%d,%d",slot_low,slot_high);
  at_command_send(AT_GEN_PB_READ,parmlist);
  mem_realloc(parmlist,0);  
}

void at_gen_phonebook_select (const char* mem) {
  char* parmlist;

  if (mem == NULL) return;
  parmlist = mem_alloc(1+strlen(mem)+2, 1);
  sprintf(parmlist,"\"%s\"",mem);
  at_command_send(AT_GEN_PB_SELECT,parmlist);
  mem_realloc(parmlist,0);  
}

void at_gen_sms_delete (unsigned int slot) {
  char* parmlist;

  parmlist = mem_alloc(numlen(slot)+1, 1);
  sprintf(parmlist,"%d",slot);
  at_command_send(AT_GEN_SMS_DELETE,parmlist);
  mem_realloc(parmlist,0);  
}

void at_gen_sms_slot_send (unsigned int slot,
			   const char* number)
{
  char* parmlist;

  if (number == NULL) return;
  parmlist = mem_alloc(numlen(slot)
		       +2+strlen(number)+2
		       +numlen(numtype(number))
		       +1,
		       1);
  if (str_len(number) == 0) {
    sprintf(parmlist,"%d",slot);
  } else {
    sprintf(parmlist,"%d,\"%s\",%d",slot,number,numtype(number));
  }
  at_command_send(AT_GEN_SMS_SLOT_SEND,parmlist);
  mem_realloc(parmlist,0);  
}

void at_gen_sms_send (unsigned int len) {
  char* parmlist;

  parmlist = mem_alloc(numlen(len)+1,1);
  sprintf(parmlist,"%d",len);
  at_command_send(AT_GEN_SMS_SEND,parmlist);
  mem_realloc(parmlist,0);  
}

void at_gen_sms_store (unsigned int len) {
  char* parmlist;

  parmlist = mem_alloc(numlen(len)+1,1);
  sprintf(parmlist,"%d",len);
  at_command_send(AT_GEN_SMS_STORE,parmlist);
  mem_realloc(parmlist,0);  
}

void at_gen_sms_mem (const char* mem1,
		     const char* mem2,
		     const char* mem3)
{
  char* parmlist;

  if (mem1 == NULL) return;
  parmlist = mem_alloc(1+strlen(mem1)+2
		       +1+str_len(mem2)+2
		       +1+str_len(mem3)+1
		       +1,
		       1);
  if (mem2 == NULL) {
    sprintf(parmlist,"\"%s\"",mem1);
  } else if (mem3 == NULL) {
    sprintf(parmlist,"\"%s\",\"%s\"",mem1,mem2);
  } else {
    sprintf(parmlist,"\"%s\",\"%s\",\"%s\"",mem1,mem2,mem3);
  }
  at_command_send(AT_GEN_SMS_MEM,parmlist);
  mem_realloc(parmlist,0);  
}

void at_gen_sms_slot_read (unsigned int slot) {
  char* parmlist;

  parmlist = mem_alloc(numlen(slot)+1,1);
  sprintf(parmlist,"%d",slot);
  at_command_send(AT_GEN_SMS_SLOT_READ,parmlist);
  mem_realloc(parmlist,0);  
}

void at_gen_sms_list_read (unsigned int list_id) {
  char* parmlist;

  parmlist = mem_alloc(numlen(list_id)+1,1);
  sprintf(parmlist,"%d",list_id);
  at_command_send(AT_GEN_SMS_LIST_READ,parmlist);
  mem_realloc(parmlist,0);  
}

void at_gen_charset (const char* charset) {
  char* parmlist;

  if (charset == NULL) return;
  parmlist = mem_alloc(1+strlen(charset)+2, 1);
  sprintf(parmlist,"\"%s\"",charset);
  at_command_send(AT_GEN_CHARSET,parmlist);
  mem_realloc(parmlist,0);
}

void at_gen_smsc (const char* number) {
  char* parmlist;

  if (number == NULL) return;
  parmlist = mem_alloc(1+strlen(number)+2
		       +numlen(numtype(number))+1,
		       1);
  sprintf(parmlist,"\"%s\",%d",number,numtype(number));
  at_command_send(AT_GEN_CHARSET,parmlist);
  mem_realloc(parmlist,0);
}

void at_gen_pin (const char* pin) {
  char* parmlist;

  if (pin == NULL) return;
  parmlist = mem_alloc(1+strlen(pin)+2,1);
  sprintf(parmlist,"\"%s\"",pin);
  at_command_send(AT_GEN_PIN,parmlist);
  mem_realloc(parmlist,0);
}

void at_gen_sms_phase (int enable) {
  char* parmlist;
  
  if (enable) parmlist = "1";
  else parmlist = "0";
  at_command_send(AT_GEN_SMS_PHASE,"1");
}

void at_gen_msg_direct (int mode, int mt, int bm, int ds) {
  char* parmlist;

  if (mode < 0 || mode > 1) return;
  if (mt < 0 || mt > 3) return;
  if (bm != 0 && bm != 2 && bm != 3) return;
  if (ds < 0 || ds > 2) return;

  parmlist = mem_alloc(numlen(mode)+1+numlen(mt)+1+
		       numlen(bm)+1+numlen(ds)+1+2,1);
  sprintf(parmlist,"%d,%d,%d,%d,1",mode,mt,bm,ds);
  at_command_send(AT_GEN_MSG_DIRECT,parmlist);
}
