
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Malolan Chetlur     
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIR_SubtractionOperator.hh"
#include "savant.hh"
#include "published_file.hh"

IIRScram_SubtractionOperator::~IIRScram_SubtractionOperator() {}

void 
IIRScram_SubtractionOperator::_publish_vhdl_operator(ostream &_vhdl_out) {
  _vhdl_out << " - ";
}

const string &
IIRScram_SubtractionOperator::_get_cc_operator_name() const {
  static const string operator_name = "vhdlMinus";
  return operator_name;
}

void
IIRScram_SubtractionOperator::_publish_cc_ams_operator_name( published_file &_cc_out ) {
  _cc_out << " - ";
}

IIR*
IIRScram_SubtractionOperator::_clone() {
  IIR_SubtractionOperator *clone = new IIR_SubtractionOperator();
  IIR_DyadicOperator::_clone(clone);
  return clone;
}

IIRScram::OperatorPrecedenceLevel
IIRScram_SubtractionOperator::_get_operator_precedence(){
  return IIRScram::ADDING_OPERATOR;
}

bool
IIRScram_SubtractionOperator::_is_associative(IIR_Kind oper_kind) {
  switch(oper_kind) {                         
  case IIR_ADDITION_OPERATOR:
  case IIR_SUBTRACTION_OPERATOR:
    return FALSE;                             
  default:
    return TRUE;                                                             
  }
}

visitor_return_type *IIRScram_SubtractionOperator::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_SubtractionOperator(this, arg);
};
