
// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Prashanth Cherukuri cherukps@ececs.uc.edu

//---------------------------------------------------------------------------

#include "IIRScram_SourceQuantityDeclaration.hh"
#include "set.hh"
#include "symbol_table.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_TerminalDeclaration.hh"
#include "IIR_Declaration.hh"
#include "IIR_Attribute.hh"
#include "IIR_IndexedName.hh"
#include "IIR.hh"

extern symbol_table *cgen_sym_tab_ptr;

IIRScram_SourceQuantityDeclaration::IIRScram_SourceQuantityDeclaration() {}

IIRScram_SourceQuantityDeclaration::~IIRScram_SourceQuantityDeclaration() {}

void
IIRScram_SourceQuantityDeclaration::_publish_vhdl_decl(ostream& _vhdl_out) {
  _vhdl_out << " quantity ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ":" ;
  get_subtype()->_publish_vhdl(_vhdl_out);
  
  if( get_phase_expression() != NULL ){
    _vhdl_out << " spectrum " ;
    get_magnitude_expression()->_publish_vhdl(_vhdl_out);
    _vhdl_out << " , " ;
    get_phase_expression()->_publish_vhdl(_vhdl_out);
  }
  else {
    _vhdl_out << " noise ";
    get_noise_expression()->_publish_vhdl(_vhdl_out);
  }
  _vhdl_out << " ;\n" ;
}

set<IIR_TypeDefinition> *
IIRScram_SourceQuantityDeclaration::_get_rval_set() {
  set<IIR_TypeDefinition> *retval = new set<IIR_TypeDefinition>;
  retval->add( get_subtype() );
  return retval;
}
